/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleEncoder;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import java.io.File;

public class ApkModuleRawEncoder
extends ApkModuleEncoder {
    private final ApkModule apkModule;

    public ApkModuleRawEncoder() {
        ZipEntryMap zipEntryMap = new ZipEntryMap();
        String name = "encoded_raw" + String.valueOf(zipEntryMap.hashCode()).substring(1);
        this.apkModule = new ApkModule(name, zipEntryMap);
    }

    @Override
    public void buildResources(File mainDirectory) {
        this.addTableBlock(mainDirectory);
    }

    @Override
    public ApkModule getApkModule() {
        return this.apkModule;
    }

    @Override
    public void encodeBinaryManifest(File mainDirectory) {
        File file = new File(mainDirectory, "AndroidManifest.xml.bin");
        if (!(file.isFile() || (file = new File(mainDirectory, "AndroidManifest.xml")).isFile() && AndroidManifestBlock.isResXmlBlock(file))) {
            this.logMessage("Warn: File not found: AndroidManifest.xml.bin");
            return;
        }
        this.logMessage("Loaded binary manifest: " + file.getName());
        FileInputSource inputSource = new FileInputSource(file, "AndroidManifest.xml");
        this.getApkModule().add(inputSource);
    }

    private void addTableBlock(File mainDirectory) {
        File file = new File(mainDirectory, "resources.arsc");
        if (!file.isFile()) {
            this.logMessage("Warn: File not found: resources.arsc");
            return;
        }
        FileInputSource inputSource = new FileInputSource(file, "resources.arsc");
        this.getApkModule().add(inputSource);
    }

    @Override
    void refreshTable() {
        if (this.getApkModule().getLoadedTableBlock() != null) {
            super.refreshTable();
        }
    }
}

