/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleCoder;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.DexEncoder;
import com.reandroid.apk.DexFileRawEncoder;
import com.reandroid.apk.PathMap;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.json.JSONArray;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class ApkModuleEncoder
extends ApkModuleCoder {
    private DexEncoder mDexEncoder;

    public void scanDirectory(File mainDirectory) throws IOException {
        this.logMessage("Scanning: " + mainDirectory.getName());
        this.encodeBinaryManifest(mainDirectory);
        this.loadUncompressedFiles(mainDirectory);
        this.buildResources(mainDirectory);
        this.encodeDexFiles(mainDirectory);
        this.scanRootDir(mainDirectory);
        this.restorePathMap(mainDirectory);
        this.restoreSignatures(mainDirectory);
        this.sortFiles();
        this.refreshTable();
    }

    public void encodeBinaryManifest(File mainDirectory) {
        File file = new File(mainDirectory, "AndroidManifest.xml.bin");
        if (!file.isFile()) {
            return;
        }
        this.logMessage("Using binary xml: " + file.getName());
        FileInputSource inputSource = new FileInputSource(file, "AndroidManifest.xml");
        this.getApkModule().add(inputSource);
    }

    public abstract void buildResources(File var1) throws IOException;

    @Override
    public abstract ApkModule getApkModule();

    void refreshTable() {
        this.logMessage("Refreshing resource table ...");
        this.getApkModule().refreshTable();
        this.logMessage(this.getApkModule().getTableBlock().toString());
    }

    private void sortFiles() {
        this.logMessage("Sorting files ...");
        ZipEntryMap archive = this.getApkModule().getZipEntryMap();
        archive.autoSortApkFiles();
    }

    private void restoreSignatures(File mainDirectory) throws IOException {
        File sigDir = new File(mainDirectory, "signatures");
        if (!sigDir.isDirectory()) {
            return;
        }
        this.logMessage("Loading signatures ...");
        ApkModule apkModule = this.getApkModule();
        ApkSignatureBlock signatureBlock = new ApkSignatureBlock();
        signatureBlock.scanSplitFiles(sigDir);
        apkModule.setApkSignatureBlock(signatureBlock);
    }

    private void restorePathMap(File mainDirectory) throws IOException {
        File file = new File(mainDirectory, "path-map.json");
        if (!file.isFile()) {
            return;
        }
        this.logMessage("Restoring original file paths ...");
        PathMap pathMap = new PathMap();
        JSONArray jsonArray = new JSONArray(file);
        pathMap.fromJson(jsonArray);
        pathMap.restore(this.getApkModule());
    }

    private void scanRootDir(File mainDirectory) {
        this.logMessage("Scanning root directory ...");
        File root = new File(mainDirectory, "root");
        ZipEntryMap archive = this.getApkModule().getZipEntryMap();
        List<File> rootFileList = ApkUtil.recursiveFiles(root);
        for (File file : rootFileList) {
            String path = ApkUtil.toArchivePath(root, file);
            FileInputSource inputSource = new FileInputSource(file, path);
            archive.add(inputSource);
        }
    }

    public void encodeDexFiles(File mainDirectory) throws IOException {
        this.logMessage("Building dex ...");
        List<InputSource> dexList = this.getRawDexEncoder().buildDexFiles(this, mainDirectory);
        ApkModule apkModule = this.getApkModule();
        apkModule.addAll(dexList);
        DexEncoder dexEncoder = this.getDexEncoder();
        if (dexEncoder != null) {
            dexList = dexEncoder.buildDexFiles(this, mainDirectory);
            apkModule.addAll(dexList);
        }
    }

    public DexEncoder getRawDexEncoder() {
        DexFileRawEncoder dexFileRawEncoder = new DexFileRawEncoder();
        dexFileRawEncoder.setApkLogger(this.getApkLogger());
        return dexFileRawEncoder;
    }

    public DexEncoder getDexEncoder() {
        return this.mDexEncoder;
    }

    public void setDexEncoder(DexEncoder dexEncoder) {
        this.mDexEncoder = dexEncoder;
    }

    void loadUncompressedFiles(File mainDirectory) throws IOException {
        File file = new File(mainDirectory, "uncompressed-files.json");
        UncompressedFiles uncompressedFiles = this.getApkModule().getUncompressedFiles();
        uncompressedFiles.fromJson(file);
    }
}

