/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkUtil;
import com.reandroid.archive.BlockInputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.header.TableHeader;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.pool.builder.StringPoolMerger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApkBundle {
    private final Map<String, ApkModule> mModulesMap = new HashMap<String, ApkModule>();
    private APKLogger apkLogger;

    public ApkModule mergeModules() throws IOException {
        List<ApkModule> moduleList = this.getApkModuleList();
        if (moduleList.size() == 0) {
            throw new FileNotFoundException("Nothing to merge, empty modules");
        }
        ApkModule result = new ApkModule(this.generateMergedModuleName(), new ZipEntryMap());
        result.setAPKLogger(this.apkLogger);
        result.setLoadDefaultFramework(false);
        this.mergeStringPools(result);
        ApkModule base = this.getBaseModule();
        if (base == null) {
            base = this.getLargestTableModule();
        }
        result.merge(base);
        ApkSignatureBlock signatureBlock = null;
        for (ApkModule module : moduleList) {
            ApkSignatureBlock asb = module.getApkSignatureBlock();
            if (module == base) {
                if (asb == null) continue;
                signatureBlock = asb;
                continue;
            }
            if (signatureBlock == null) {
                signatureBlock = asb;
            }
            result.merge(module);
        }
        result.setApkSignatureBlock(signatureBlock);
        if (result.hasTableBlock()) {
            TableBlock tableBlock = result.getTableBlock();
            tableBlock.sortPackages();
            tableBlock.refresh();
        }
        result.getZipEntryMap().autoSortApkFiles();
        return result;
    }

    private void mergeStringPools(ApkModule mergedModule) throws IOException {
        if (!this.hasOneTableBlock() || mergedModule.hasTableBlock()) {
            return;
        }
        this.logMessage("Merging string pools ... ");
        TableBlock createdTable = new TableBlock();
        BlockInputSource<TableBlock> inputSource = new BlockInputSource<TableBlock>("resources.arsc", createdTable);
        mergedModule.getZipEntryMap().add(inputSource);
        StringPoolMerger poolMerger = new StringPoolMerger();
        for (ApkModule apkModule : this.getModules()) {
            if (!apkModule.hasTableBlock()) continue;
            TableStringPool stringPool = apkModule.getVolatileTableStringPool();
            poolMerger.add(stringPool);
        }
        poolMerger.mergeTo(createdTable.getTableStringPool());
        this.logMessage("Merged string pools=" + poolMerger.getMergedPools() + ", style=" + poolMerger.getMergedStyleStrings() + ", strings=" + poolMerger.getMergedStrings());
    }

    private String generateMergedModuleName() {
        Set<String> moduleNames = this.mModulesMap.keySet();
        String merged = "merged";
        int i = 1;
        String name = merged;
        while (moduleNames.contains(name)) {
            name = merged + "_" + i;
            ++i;
        }
        return name;
    }

    private ApkModule getLargestTableModule() {
        ApkModule apkModule = null;
        int chunkSize = 0;
        for (ApkModule module : this.getApkModuleList()) {
            if (!module.hasTableBlock()) continue;
            TableBlock tableBlock = module.getTableBlock();
            int size = ((TableHeader)tableBlock.getHeaderBlock()).getChunkSize();
            if (apkModule != null && size <= chunkSize) continue;
            chunkSize = size;
            apkModule = module;
        }
        return apkModule;
    }

    public ApkModule getBaseModule() {
        for (ApkModule module : this.getApkModuleList()) {
            if (!module.isBaseModule()) continue;
            return module;
        }
        return null;
    }

    public List<ApkModule> getApkModuleList() {
        return new ArrayList<ApkModule>(this.mModulesMap.values());
    }

    public void loadApkDirectory(File dir) throws IOException {
        this.loadApkDirectory(dir, false);
    }

    public void loadApkDirectory(File dir, boolean recursive) throws IOException {
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("No such directory: " + dir);
        }
        List<File> apkList = recursive ? ApkUtil.recursiveFiles(dir, ".apk") : ApkUtil.listFiles(dir, ".apk");
        if (apkList.size() == 0) {
            throw new FileNotFoundException("No '*.apk' files in directory: " + dir);
        }
        this.logMessage("Found apk files: " + apkList.size());
        for (File file : apkList) {
            this.logVerbose("Loading: " + file.getName());
            String name = ApkUtil.toModuleName(file);
            ApkModule module = ApkModule.loadApkFile(file, name);
            module.setAPKLogger(this.apkLogger);
            this.addModule(module);
        }
    }

    public void addModule(ApkModule apkModule) {
        apkModule.setLoadDefaultFramework(false);
        String name = apkModule.getModuleName();
        this.mModulesMap.remove(name);
        this.mModulesMap.put(name, apkModule);
    }

    public boolean containsApkModule(String moduleName) {
        return this.mModulesMap.containsKey(moduleName);
    }

    public ApkModule removeApkModule(String moduleName) {
        return this.mModulesMap.remove(moduleName);
    }

    public ApkModule getApkModule(String moduleName) {
        return this.mModulesMap.get(moduleName);
    }

    public List<String> listModuleNames() {
        return new ArrayList<String>(this.mModulesMap.keySet());
    }

    public int countModules() {
        return this.mModulesMap.size();
    }

    public Collection<ApkModule> getModules() {
        return this.mModulesMap.values();
    }

    private boolean hasOneTableBlock() {
        for (ApkModule apkModule : this.getModules()) {
            if (!apkModule.hasTableBlock()) continue;
            return true;
        }
        return false;
    }

    public void setAPKLogger(APKLogger logger) {
        this.apkLogger = logger;
    }

    private void logMessage(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logMessage(msg);
        }
    }

    private void logError(String msg, Throwable tr) {
        if (this.apkLogger != null) {
            this.apkLogger.logError(msg, tr);
        }
    }

    private void logVerbose(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logVerbose(msg);
        }
    }
}

