/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertySubstitute;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;

public class TypeDescription {
    private static final Logger log = Logger.getLogger(TypeDescription.class.getPackage().getName());
    private final Class<? extends Object> type;
    private Class<?> impl;
    private Tag tag;
    private transient Set<Property> dumpProperties;
    private transient PropertyUtils propertyUtils;
    private transient boolean delegatesChecked;
    private Map<String, PropertySubstitute> properties = Collections.emptyMap();
    protected Set<String> excludes = Collections.emptySet();
    protected String[] includes = null;
    protected BeanAccess beanAccess;

    public TypeDescription(Class<? extends Object> clazz, Tag tag, Class<?> impl) {
        this.type = clazz;
        this.tag = tag;
        this.impl = impl;
        this.beanAccess = null;
    }

    public TypeDescription(Class<? extends Object> clazz) {
        this(clazz, new Tag(clazz), null);
    }

    public Tag getTag() {
        return this.tag;
    }

    public Class<? extends Object> getType() {
        return this.type;
    }

    public String toString() {
        return "TypeDescription for " + this.getType() + " (tag='" + this.getTag() + "')";
    }

    private void checkDelegates() {
        Collection<PropertySubstitute> values = this.properties.values();
        for (PropertySubstitute p : values) {
            try {
                p.setDelegate(this.discoverProperty(p.getName()));
            }
            catch (YAMLException yAMLException) {}
        }
        this.delegatesChecked = true;
    }

    private Property discoverProperty(String name) {
        if (this.propertyUtils != null) {
            if (this.beanAccess == null) {
                return this.propertyUtils.getProperty(this.type, name);
            }
            return this.propertyUtils.getProperty(this.type, name, this.beanAccess);
        }
        return null;
    }

    public Property getProperty(String name) {
        if (!this.delegatesChecked) {
            this.checkDelegates();
        }
        return this.properties.containsKey(name) ? (Property)this.properties.get(name) : this.discoverProperty(name);
    }

    public void setPropertyUtils(PropertyUtils propertyUtils) {
        this.propertyUtils = propertyUtils;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Property> getProperties() {
        if (this.dumpProperties != null) {
            return this.dumpProperties;
        }
        if (this.propertyUtils != null) {
            Set<Property> readableProps;
            if (this.includes != null) {
                void var3_7;
                this.dumpProperties = new LinkedHashSet<Property>();
                String[] stringArray = this.includes;
                int n = stringArray.length;
                boolean bl = false;
                while (var3_7 < n) {
                    String propertyName = stringArray[var3_7];
                    if (!this.excludes.contains(propertyName)) {
                        this.dumpProperties.add(this.getProperty(propertyName));
                    }
                    ++var3_7;
                }
                return this.dumpProperties;
            }
            Set<Property> set = readableProps = this.beanAccess == null ? this.propertyUtils.getProperties(this.type) : this.propertyUtils.getProperties(this.type, this.beanAccess);
            if (this.properties.isEmpty()) {
                if (this.excludes.isEmpty()) {
                    this.dumpProperties = readableProps;
                    return this.dumpProperties;
                }
                this.dumpProperties = new LinkedHashSet<Property>();
                for (Property property : readableProps) {
                    if (this.excludes.contains(property.getName())) continue;
                    this.dumpProperties.add(property);
                }
                return this.dumpProperties;
            }
            if (!this.delegatesChecked) {
                this.checkDelegates();
            }
            this.dumpProperties = new LinkedHashSet<Property>();
            for (Property property : this.properties.values()) {
                if (this.excludes.contains(property.getName()) || !property.isReadable()) continue;
                this.dumpProperties.add(property);
            }
            for (Property property : readableProps) {
                if (this.excludes.contains(property.getName())) continue;
                this.dumpProperties.add(property);
            }
            return this.dumpProperties;
        }
        return null;
    }

    public boolean setupPropertyType(String key, Node valueNode) {
        return false;
    }

    public boolean setProperty(Object targetBean, String propertyName, Object value) throws Exception {
        return false;
    }

    public Object newInstance(Node node) {
        if (this.impl != null) {
            try {
                Constructor<?> c = this.impl.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                return c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.fine(e.getLocalizedMessage());
                this.impl = null;
            }
        }
        return null;
    }

    public Object newInstance(String propertyName, Node node) {
        return null;
    }

    public Object finalizeConstruction(Object obj) {
        return obj;
    }
}

