/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.util.Duo;
import java.io.IOException;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlSerializer;

public class ResStyleValue
extends ResBagValue {
    private final Duo<ResReferenceValue, ResScalarValue>[] mItems;
    private static final Logger LOGGER = Logger.getLogger(ResStyleValue.class.getName());

    ResStyleValue(ResReferenceValue parent, Duo<Integer, ResScalarValue>[] items, ResValueFactory factory) {
        super(parent);
        this.mItems = new Duo[items.length];
        for (int i = 0; i < items.length; ++i) {
            this.mItems[i] = new Duo<ResReferenceValue, ResScalarValue>(factory.newReference((Integer)items[i].m1, null), (ResScalarValue)items[i].m2);
        }
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws IOException, AndrolibException {
        serializer.startTag(null, "style");
        serializer.attribute(null, "name", res.getResSpec().getName());
        if (!this.mParent.isNull() && !this.mParent.referentIsNull()) {
            serializer.attribute(null, "parent", this.mParent.encodeAsResXmlAttr());
        } else if (res.getResSpec().getName().indexOf(46) != -1) {
            serializer.attribute(null, "parent", "");
        }
        for (Duo<ResReferenceValue, ResScalarValue> mItem : this.mItems) {
            String name;
            ResResSpec spec = ((ResReferenceValue)mItem.m1).getReferent();
            if (spec == null) {
                LOGGER.fine(String.format("null reference: m1=0x%08x(%s), m2=0x%08x(%s)", ((ResReferenceValue)mItem.m1).getRawIntValue(), ((ResReferenceValue)mItem.m1).getType(), ((ResScalarValue)mItem.m2).getRawIntValue(), ((ResScalarValue)mItem.m2).getType()));
                continue;
            }
            String value = null;
            ResValue resource = spec.getDefaultResource().getValue();
            if (resource instanceof ResReferenceValue) continue;
            if (resource instanceof ResAttr) {
                ResAttr attr = (ResAttr)resource;
                value = attr.convertToResXmlFormat((ResScalarValue)mItem.m2);
                name = spec.getFullName(res.getResSpec().getPackage(), true);
            } else {
                name = "@" + spec.getFullName(res.getResSpec().getPackage(), false);
            }
            if (value == null) {
                value = ((ResScalarValue)mItem.m2).encodeAsResXmlValue();
            }
            if (value == null) continue;
            serializer.startTag(null, "item");
            serializer.attribute(null, "name", name);
            serializer.text(value);
            serializer.endTag(null, "item");
        }
        serializer.endTag(null, "style");
    }
}

