/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractIndexedListIterator
extends UnmodifiableIterator
implements ListIterator {
    public final int size;
    public int position;

    public AbstractIndexedListIterator(int n, int n2) {
        AbstractIndexedListIterator abstractIndexedListIterator = this;
        Preconditions.checkPositionIndex(n2, n);
        abstractIndexedListIterator.size = n;
        abstractIndexedListIterator.position = n2;
    }

    public abstract Object get(int var1);

    @Override
    public final boolean hasNext() {
        return this.position < this.size;
    }

    @Override
    public final Object next() {
        if (this.hasNext()) {
            AbstractIndexedListIterator abstractIndexedListIterator = this;
            int n = abstractIndexedListIterator.position;
            abstractIndexedListIterator.position = n + 1;
            return abstractIndexedListIterator.get(n);
        }
        throw new NoSuchElementException();
    }

    @Override
    public final int nextIndex() {
        return this.position;
    }

    @Override
    public final boolean hasPrevious() {
        return this.position > 0;
    }

    public final Object previous() {
        if (this.hasPrevious()) {
            int n;
            AbstractIndexedListIterator abstractIndexedListIterator = this;
            abstractIndexedListIterator.position = n = abstractIndexedListIterator.position - 1;
            return abstractIndexedListIterator.get(n);
        }
        throw new NoSuchElementException();
    }

    @Override
    public final int previousIndex() {
        return this.position - 1;
    }

    public final void add(Object object) {
        throw new UnsupportedOperationException();
    }

    public final void set(Object object) {
        throw new UnsupportedOperationException();
    }
}

