/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AaptManager;
import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.meta.ApkInfo;
import brut.androlib.meta.SdkInfo;
import brut.common.BrutException;
import brut.directory.ExtFile;
import brut.util.OS;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public final class AaptInvoker {
    public static final Logger LOGGER = Logger.getLogger(AaptInvoker.class.getName());
    public final ApkInfo mApkInfo;
    public final Config mConfig;

    public AaptInvoker(ApkInfo apkInfo, Config config) {
        this.mApkInfo = apkInfo;
        this.mConfig = config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void invoke(ExtFile serializable, File file, File object, File file2, File[] fileArray) {
        ArrayList arrayList;
        int n;
        Iterator iterator = this.mConfig;
        Object object2 = ((Config)((Object)iterator)).mAaptBinary;
        if (object2 != null) {
            iterator = ((File)object2).getPath();
            n = 1;
        } else {
            try {
                iterator = AaptManager.getAaptBinary(((Config)((Object)iterator)).mAaptVersion).getPath();
                n = 0;
            }
            catch (AndrolibException androlibException) {
                object2 = this.mConfig.mAaptVersion != 2 ? "aapt" : "aapt2";
                int n2 = 1;
                LOGGER.warning((String)object2 + ": " + androlibException.getMessage() + " (defaulting to $PATH binary)");
                n = n2;
                iterator = object2;
            }
        }
        if (this.mConfig.mAaptVersion != 2) {
            ArrayList<Object> arrayList2;
            ArrayList<Object> arrayList3 = arrayList2;
            arrayList2 = new ArrayList<Object>();
            arrayList3.add(iterator);
            arrayList3.add("p");
            if (this.mConfig.mVerbose) {
                arrayList3.add("-v");
            }
            if (this.mConfig.mDebugMode) {
                arrayList3.add("--debug-mode");
            }
            if (this.mConfig.mNoCrunch) {
                arrayList3.add("--no-crunch");
            }
            if ((iterator = this.mApkInfo.mPackageInfo.mForcedPackageId) != null) {
                int n3 = Integer.parseInt((String)((Object)iterator));
                if (n3 == 0) {
                    arrayList3.add("--shared-lib");
                } else if (n3 > 0) {
                    if (n == 0) {
                        arrayList3.add("--forced-package-id");
                        arrayList3.add(Integer.toString(n3));
                    }
                    if (n3 < 127) {
                        arrayList3.add("-x");
                    }
                }
            }
            if (this.mApkInfo.mSdkInfo.mMinSdkVersion != null) {
                arrayList3.add("--min-sdk-version");
                arrayList3.add(this.mApkInfo.mSdkInfo.mMinSdkVersion);
            }
            if (this.mApkInfo.mSdkInfo.mTargetSdkVersion != null) {
                arrayList3.add("--target-sdk-version");
                Object object3 = this.mApkInfo.mSdkInfo;
                n = SdkInfo.parseSdkInt(((SdkInfo)object3).mTargetSdkVersion);
                String string = ((SdkInfo)object3).mMinSdkVersion;
                int n4 = string != null ? SdkInfo.parseSdkInt(string) : 0;
                object3 = ((SdkInfo)object3).mMaxSdkVersion;
                int n5 = object3 != null ? SdkInfo.parseSdkInt((String)object3) : n;
                arrayList3.add(Integer.toString(Math.max(n4, Math.min(n5, n))));
            }
            if (this.mApkInfo.mSdkInfo.mMaxSdkVersion != null) {
                arrayList3.add("--max-sdk-version");
                arrayList3.add(this.mApkInfo.mSdkInfo.mMaxSdkVersion);
                arrayList3.add("--max-res-version");
                arrayList3.add(this.mApkInfo.mSdkInfo.mMaxSdkVersion);
            }
            if (this.mApkInfo.mPackageInfo.mRenameManifestPackage != null) {
                arrayList3.add("--rename-manifest-package");
                arrayList3.add(this.mApkInfo.mPackageInfo.mRenameManifestPackage);
            }
            if (this.mApkInfo.mVersionInfo.mVersionCode != null) {
                arrayList3.add("--version-code");
                arrayList3.add(this.mApkInfo.mVersionInfo.mVersionCode);
            }
            if (this.mApkInfo.mVersionInfo.mVersionName != null) {
                arrayList3.add("--version-name");
                arrayList3.add(this.mApkInfo.mVersionInfo.mVersionName);
            }
            arrayList3.add("--no-version-vectors");
            arrayList3.add("-F");
            arrayList3.add(((File)serializable).getAbsolutePath());
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    arrayList3.add("-I");
                    arrayList3.add(file3.getPath());
                }
            }
            if (object != null) {
                arrayList3.add("-S");
                arrayList3.add(((File)object).getAbsolutePath());
            }
            arrayList3.add("-M");
            arrayList3.add(file.getAbsolutePath());
            if (file2 != null) {
                arrayList3.add(file2.getAbsolutePath());
            }
            try {
                OS.exec(arrayList3.toArray(new String[0]));
                Logger logger = LOGGER;
                logger.fine("command ran: ");
                logger.fine(((Object)arrayList3).toString());
                return;
            }
            catch (BrutException brutException) {
                throw new AndrolibException(brutException);
            }
        }
        File file4 = null;
        if (object != null && !(file4 = Paths.get(((File)object).getParent(), "build", "resources.zip").toFile()).exists()) {
            Logger logger;
            ArrayList<Object> arrayList4;
            ArrayList<Object> arrayList5;
            ArrayList<Object> arrayList6 = arrayList5 = arrayList4;
            ArrayList<Object> arrayList7 = arrayList5;
            arrayList5();
            arrayList7.add(iterator);
            arrayList7.add("compile");
            arrayList7.add("--dir");
            arrayList6.add(((File)object).getAbsolutePath());
            arrayList6.add("--legacy");
            arrayList6.add("-o");
            arrayList4.add(file4.getAbsolutePath());
            if (this.mConfig.mVerbose) {
                arrayList5.add("-v");
            }
            if (this.mConfig.mNoCrunch) {
                arrayList5.add("--no-crunch");
            }
            try {
                OS.exec(arrayList5.toArray(new String[0]));
                logger = LOGGER;
            }
            catch (BrutException brutException) {
                throw new AndrolibException(brutException);
            }
            logger.fine("aapt2 compile command ran: ");
            logger.fine(((Object)arrayList5).toString());
        }
        Serializable serializable2 = serializable;
        serializable = arrayList;
        arrayList = new ArrayList();
        ((ArrayList)serializable).add(iterator);
        ((ArrayList)serializable).add("link");
        ((ArrayList)serializable).add("-o");
        ((ArrayList)serializable).add(((File)serializable2).getAbsolutePath());
        object = this.mApkInfo.mPackageInfo.mForcedPackageId;
        if (object != null) {
            int n6 = Integer.parseInt((String)object);
            if (n6 == 0) {
                ((ArrayList)serializable).add("--shared-lib");
            } else if (n6 > 1) {
                int n7 = n6;
                ((ArrayList)serializable).add("--package-id");
                ((ArrayList)serializable).add(Integer.toString(n7));
                if (n7 < 127) {
                    ((ArrayList)serializable).add("--allow-reserved-package-id");
                }
            }
        }
        if (this.mApkInfo.mSdkInfo.mMinSdkVersion != null) {
            ((ArrayList)serializable).add("--min-sdk-version");
            ((ArrayList)serializable).add(this.mApkInfo.mSdkInfo.mMinSdkVersion);
        }
        if (this.mApkInfo.mSdkInfo.mTargetSdkVersion != null) {
            ((ArrayList)serializable).add("--target-sdk-version");
            ((ArrayList)serializable).add(this.mApkInfo.mSdkInfo.mTargetSdkVersion);
        }
        if (this.mApkInfo.mPackageInfo.mRenameManifestPackage != null) {
            ((ArrayList)serializable).add("--rename-manifest-package");
            ((ArrayList)serializable).add(this.mApkInfo.mPackageInfo.mRenameManifestPackage);
            ((ArrayList)serializable).add("--rename-instrumentation-target-package");
            ((ArrayList)serializable).add(this.mApkInfo.mPackageInfo.mRenameManifestPackage);
        }
        if (this.mApkInfo.mVersionInfo.mVersionCode != null) {
            ((ArrayList)serializable).add("--version-code");
            ((ArrayList)serializable).add(this.mApkInfo.mVersionInfo.mVersionCode);
        }
        if (this.mApkInfo.mVersionInfo.mVersionName != null) {
            ((ArrayList)serializable).add("--version-name");
            ((ArrayList)serializable).add(this.mApkInfo.mVersionInfo.mVersionName);
        }
        ((ArrayList)serializable).add("--no-auto-version");
        ((ArrayList)serializable).add("--no-version-vectors");
        ((ArrayList)serializable).add("--no-version-transitions");
        ((ArrayList)serializable).add("--no-resource-deduping");
        ((ArrayList)serializable).add("--no-compile-sdk-metadata");
        ((ArrayList)serializable).add("--warn-manifest-validation");
        Serializable serializable3 = this.mApkInfo.mSparseResources;
        if (serializable3 != null ? (Boolean)serializable3 : false) {
            ((ArrayList)serializable).add("--enable-sparse-encoding");
        }
        if ((serializable3 = this.mApkInfo.mCompactEntries) != null ? (Boolean)serializable3 : false) {
            ((ArrayList)serializable).add("--enable-compact-entries");
        }
        if (!this.mApkInfo.mFeatureFlags.isEmpty()) {
            ArrayList arrayList8;
            serializable3 = arrayList8;
            arrayList8 = new ArrayList();
            for (Map.Entry entry : this.mApkInfo.mFeatureFlags.entrySet()) {
                ((ArrayList)serializable3).add((String)entry.getKey() + "=" + entry.getValue());
            }
            ((ArrayList)serializable).add("--feature-flags");
            ((ArrayList)serializable).add(String.join((CharSequence)",", (Iterable<? extends CharSequence>)((Object)serializable3)));
        }
        if (fileArray != null) {
            for (File file5 : fileArray) {
                ((ArrayList)serializable).add("-I");
                ((ArrayList)serializable).add(file5.getPath());
            }
        }
        ((ArrayList)serializable).add("--manifest");
        ((ArrayList)serializable).add(file.getAbsolutePath());
        if (file2 != null) {
            ((ArrayList)serializable).add("-R");
            ((ArrayList)serializable).add(file2.getAbsolutePath());
        }
        if (this.mConfig.mVerbose) {
            ((ArrayList)serializable).add("-v");
        }
        if (file4 != null) {
            ((ArrayList)serializable).add(file4.getAbsolutePath());
        }
        try {
            OS.exec(((ArrayList)serializable).toArray(new String[0]));
            Logger logger = LOGGER;
            logger.fine("aapt2 link command ran: ");
            logger.fine(serializable.toString());
            return;
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
    }
}

