/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteStreams {
    private static final byte[] DUMMY_BUFFER = new byte[4096];

    public static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static void skipFully(InputStream in, long n) throws IOException {
        long skipped = ByteStreams.skipUpTo(in, n);
        if (skipped < n) {
            throw new EOFException("reached end of stream after skipping " + skipped + " bytes; " + n + " bytes expected");
        }
    }

    static long skipUpTo(InputStream in, long n) throws IOException {
        long remaining;
        int skip;
        long totalSkipped;
        long skipped;
        byte[] buf = DUMMY_BUFFER;
        for (totalSkipped = 0L; totalSkipped < n && (skipped = (long)in.read(buf, 0, skip = (int)Math.min(remaining = n - totalSkipped, (long)buf.length))) != -1L; totalSkipped += skipped) {
        }
        return totalSkipped;
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        ByteStreams.readFully(in, b, 0, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int read = in.read(b, off, len);
        if (read != len) {
            throw new EOFException("reached end of stream after reading " + read + " bytes; " + len + " bytes expected");
        }
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        int length;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[40960];
        while ((length = in.read(buffer)) > 0) {
            outputStream.write(buffer, 0, length);
        }
        outputStream.close();
        in.close();
        return outputStream.toByteArray();
    }

    public static byte[] toByteArray(File file) throws IOException {
        int length;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream((int)file.length());
        FileInputStream inputStream = new FileInputStream(file);
        byte[] buffer = new byte[8192];
        while ((length = ((InputStream)inputStream).read(buffer)) > 0) {
            outputStream.write(buffer, 0, length);
        }
        outputStream.close();
        ((InputStream)inputStream).close();
        return outputStream.toByteArray();
    }
}

