/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.XmlSerializerWrapper;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public class XmlIndentingSerializer
extends XmlSerializerWrapper {
    public XmlIndentingSerializer(XmlSerializer baseSerializer) {
        super(baseSerializer);
    }

    @Override
    public void startDocument(String encoding, Boolean standalone) throws IOException, IllegalArgumentException, IllegalStateException {
        super.startDocument(encoding, standalone);
        this.setIndentFeature();
    }

    @Override
    public XmlSerializer startTag(String namespace, String name) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setIndentFeature();
        return super.startTag(namespace, name);
    }

    private void setIndentFeature() {
        XMLUtil.setFeatureSafe(this, XMLUtil.FEATURE_INDENT_OUTPUT, true);
    }

    public static XmlSerializer create(XmlSerializer serializer) {
        if (XmlIndentingSerializer.containsIndenting(serializer)) {
            return serializer;
        }
        return new XmlIndentingSerializer(serializer);
    }

    private static boolean containsIndenting(XmlSerializer serializer) {
        while (!(serializer instanceof XmlIndentingSerializer) && serializer instanceof XmlSerializerWrapper) {
            serializer = ((XmlSerializerWrapper)serializer).getBaseSerializer();
        }
        return serializer instanceof XmlIndentingSerializer;
    }
}

