/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.io.FileUtil;
import com.reandroid.xml.CloseableParser;
import com.reandroid.xml.CloseableSerializer;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.XmlSerializerWrapper;
import com.reandroid.xml.kxml2.KXmlSerializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLFactory {
    public static XmlPullParser newPullParser(String xmlContent) throws XmlPullParserException {
        XmlPullParser parser = XMLFactory.newPullParser();
        StringReader reader = new StringReader(xmlContent);
        parser.setInput(reader);
        XMLUtil.setLocation(parser, "<XML_STRING>");
        return parser;
    }

    public static XmlPullParser newPullParser(File file) throws XmlPullParserException {
        XmlPullParser parser = XMLFactory.newPullParser();
        try {
            parser.setInput(FileUtil.inputStream(file), null);
            XMLUtil.setLocation(parser, file);
        }
        catch (IOException ex) {
            throw new XmlPullParserException(ex.getMessage());
        }
        return parser;
    }

    public static XmlPullParser newPullParser(Reader reader) throws XmlPullParserException {
        XmlPullParser parser = XMLFactory.newPullParser();
        parser.setInput(reader);
        return parser;
    }

    public static XmlPullParser newPullParser(InputStream inputStream) throws XmlPullParserException {
        XmlPullParser parser = XMLFactory.newPullParser();
        parser.setInput(inputStream, null);
        return parser;
    }

    public static XmlPullParser newPullParser() {
        CloseableParser parser = new CloseableParser();
        try {
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return parser;
    }

    public static XmlSerializer newSerializer(Writer writer) throws IOException {
        XmlSerializer serializer = XMLFactory.newSerializer();
        serializer.setOutput(writer);
        return serializer;
    }

    public static XmlSerializer newSerializer(File file) throws IOException {
        return XMLFactory.newSerializer(FileUtil.outputStream(file));
    }

    public static XmlSerializer newSerializer(File file, String encoding) throws IOException {
        return XMLFactory.newSerializer(FileUtil.outputStream(file), encoding);
    }

    public static XmlSerializer newSerializer(OutputStream outputStream) throws IOException {
        XmlSerializer serializer = XMLFactory.newSerializer();
        serializer.setOutput(outputStream, "utf-8");
        return serializer;
    }

    public static XmlSerializer newSerializer(OutputStream outputStream, String encoding) throws IOException {
        XmlSerializer serializer = XMLFactory.newSerializer();
        if (encoding == null) {
            encoding = "utf-8";
        }
        serializer.setOutput(outputStream, encoding);
        return serializer;
    }

    public static XmlSerializer newSerializer() {
        return new CloseableSerializer();
    }

    public static void setEnableIndentAttributes(XmlSerializer serializer, boolean indentAttributes) {
        KXmlSerializer kXmlSerializer = XMLFactory.getKXmlSerializer(serializer);
        if (kXmlSerializer != null) {
            kXmlSerializer.setEnableIndentAttributes(indentAttributes);
        }
    }

    private static KXmlSerializer getKXmlSerializer(XmlSerializer serializer) {
        if (serializer instanceof KXmlSerializer) {
            return (KXmlSerializer)serializer;
        }
        while (serializer instanceof XmlSerializerWrapper) {
            if (!((serializer = ((XmlSerializerWrapper)serializer).getBaseSerializer()) instanceof KXmlSerializer)) continue;
            return (KXmlSerializer)serializer;
        }
        return null;
    }
}

