/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.StringsUtil;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLDocType
extends XMLNode {
    private String mName;

    public XMLDocType(String text) {
        this.mName = text;
    }

    public XMLDocType() {
        this(null);
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    @Override
    void write(Appendable writer, boolean xml, boolean escapeXmlText) throws IOException {
        String type = this.getName();
        if (type != null) {
            writer.append("<!DOCTYPE");
            writer.append(' ');
            writer.append(type);
            writer.append('>');
        }
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        XMLUtil.expectEvent(parser, 10);
        String type = StringsUtil.trimStart(parser.getText(), ' ');
        this.setName(type);
        if (type != null && type.contains("html")) {
            XMLUtil.setFeatureRelaxed(parser, true);
        }
        parser.nextToken();
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        String type = this.getName();
        if (type != null) {
            serializer.docdecl(" " + type);
        }
    }

    @Override
    public String toString() {
        return "<!DOCTYPE " + this.getName() + ">";
    }
}

