/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.xml.DocumentSerializer;
import com.reandroid.xml.Span;
import com.reandroid.xml.SpanSet;
import com.reandroid.xml.StyleDocument;
import com.reandroid.xml.StyleSpanEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class StyleSpanEventSet {
    private final List<StyleSpanEvent> eventList = new ArrayCollection<StyleSpanEvent>();

    public void addChar(char ch) {
        this.add(new StyleSpanEvent(ch));
    }

    public void addStart(Span span) {
        this.add(new StyleSpanEvent(StyleSpanEvent.TYPE_START_TAG, span));
    }

    public void addEnd(Span span) {
        this.add(new StyleSpanEvent(StyleSpanEvent.TYPE_END_TAG, span));
    }

    public void addStartEnd(Span span) {
        this.add(new StyleSpanEvent(StyleSpanEvent.TYPE_START_END, span));
    }

    public void add(StyleSpanEvent styleSpanEvent) {
        this.eventList.add(styleSpanEvent);
    }

    private List<StyleSpanEvent> getEventList() {
        List<StyleSpanEvent> eventList = this.eventList;
        eventList.sort(CompareUtil.getComparableComparator());
        return eventList;
    }

    public void serialize(XmlSerializer serializer) throws IOException {
        List<StyleSpanEvent> eventList = this.getEventList();
        int size = eventList.size();
        for (int i = 0; i < size; ++i) {
            StyleSpanEvent event = eventList.get(i);
            event.serialize(serializer);
        }
    }

    public static StyleDocument serialize(String text, SpanSet<?> spanSet) {
        try {
            StyleSpanEventSet[] holders = StyleSpanEventSet.create(text, spanSet);
            StyleDocument document = new StyleDocument();
            DocumentSerializer serializer = new DocumentSerializer(document);
            for (StyleSpanEventSet holder : holders) {
                holder.serialize(serializer);
            }
            return document;
        }
        catch (IOException ignored) {
            return null;
        }
    }

    private static StyleSpanEventSet[] create(String text, SpanSet<?> spanSet) {
        StyleSpanEventSet[] results = StyleSpanEventSet.create(text);
        StyleSpanEventSet.fill(results, spanSet);
        return results;
    }

    private static StyleSpanEventSet[] create(String text) {
        int length = text.length();
        StyleSpanEventSet[] results = new StyleSpanEventSet[length + 1];
        for (int i = 0; i < length; ++i) {
            StyleSpanEventSet eventSet = new StyleSpanEventSet();
            eventSet.addChar(text.charAt(i));
            results[i] = eventSet;
        }
        results[length] = new StyleSpanEventSet();
        return results;
    }

    private static void fill(StyleSpanEventSet[] spanEventSets, SpanSet<?> spanSet) {
        Iterator<?> iterator = spanSet.getSpans();
        while (iterator.hasNext()) {
            int end;
            Span span = (Span)iterator.next();
            int start = span.getFirstChar();
            if (start >= spanEventSets.length || (end = span.getLastChar()) >= spanEventSets.length) continue;
            StyleSpanEventSet eventSet = spanEventSets[start];
            if (start >= end) {
                eventSet.addStartEnd(span);
                continue;
            }
            eventSet.addStart(span);
            eventSet = spanEventSets[end];
            eventSet.addEnd(span);
        }
    }
}

