/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.StringsUtil;
import com.reandroid.xml.Span;
import com.reandroid.xml.StyleAttribute;
import com.reandroid.xml.StyleElement;

public class SpanAttributesDecoder {
    private final StyleElement element;
    private final String encodedAttributes;
    private final int length;
    private boolean error;
    private int index;

    public SpanAttributesDecoder(StyleElement element, String encodedAttributes) {
        this.element = element;
        this.encodedAttributes = encodedAttributes;
        this.length = encodedAttributes.length();
    }

    public boolean decode() {
        this.reset();
        while (this.parseNext()) {
        }
        return this.error;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseNext() {
        String name = this.pickAttributeName();
        String value = this.pickAttributeValue();
        if (name == null && value == null) {
            return false;
        }
        if (name != null && value != null) {
            StyleAttribute attribute = new StyleAttribute();
            attribute.set(name, value);
            this.element.addAttribute(attribute);
            return true;
        }
        StyleAttribute last = this.getLastAttribute();
        if (last == null) {
            this.onError();
            return false;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(last.getValueAsString());
        builder.append(';');
        if (name == null) {
            builder.append(value);
        } else {
            builder.append(name);
            builder.append('=');
        }
        last.setValue(builder.toString());
        return true;
    }

    private void onError() {
        this.element.clearAttributes();
        this.index = this.length;
        this.error = true;
        StyleAttribute attribute = new StyleAttribute();
        attribute.set(Span.RAW_STYLE_TAG_ATTRIBUTE, this.encodedAttributes);
        this.element.addAttribute(attribute);
    }

    private StyleAttribute getLastAttribute() {
        int count = this.element.getAttributeCount();
        if (count != 0) {
            return this.element.getAttributeAt(count - 1);
        }
        return null;
    }

    private String pickAttributeName() {
        int length = this.length - 1;
        for (int i = this.index; i < length; ++i) {
            char c = this.encodedAttributes.charAt(i);
            if (c != '=') continue;
            String name = this.encodedAttributes.substring(this.index, i);
            if (this.isAttributeName(name)) {
                this.index = i + 1;
                return name;
            }
            return null;
        }
        return null;
    }

    private String pickAttributeValue() {
        int i;
        int length = this.length - 1;
        for (i = this.index; i < length; ++i) {
            char c = this.encodedAttributes.charAt(i);
            if (c != ';') continue;
            String result = this.encodedAttributes.substring(this.index, i);
            this.index = i + 1;
            return result;
        }
        length = this.length;
        if (this.index < length) {
            i = this.index;
            this.index = length;
            return this.encodedAttributes.substring(i);
        }
        return null;
    }

    private void reset() {
        this.element.clearAttributes();
        this.index = 0;
        this.error = false;
    }

    private boolean isAttributeName(String name) {
        int length = name.length();
        if (length == 0) {
            return false;
        }
        if (!this.isFirstAttributeChar(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            if (this.isAttributeChar(name.charAt(i))) continue;
            return false;
        }
        StyleAttribute last = this.getLastAttribute();
        return last == null || name.compareTo(last.getName()) >= 0;
    }

    private boolean isFirstAttributeChar(char c) {
        return StringsUtil.isAz(c);
    }

    private boolean isAttributeChar(char c) {
        if (StringsUtil.isAzOrDigits(c)) {
            return true;
        }
        return c == '_';
    }
}

