/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.io;

import com.reandroid.common.ByteSource;
import com.reandroid.common.FileChannelInputStream;
import java.io.File;
import java.io.IOException;

public class FileByteSource
implements ByteSource {
    private byte[] array;
    private File file;
    private int length;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) throws IOException {
        this.file = file;
        int length = (int)file.length();
        byte[] array = this.array;
        if (array == null || length > array.length) {
            this.array = array = new byte[length];
        }
        this.length = length;
        FileChannelInputStream.read(file, array, length);
    }

    @Override
    public byte read(int i) {
        if (i > this.length) {
            throw new IndexOutOfBoundsException("Out of range: " + i + ", max = " + this.length);
        }
        return this.array[i];
    }

    @Override
    public void read(int position, byte[] buffer, int offset, int length) {
        if (position + length > this.length) {
            throw new IndexOutOfBoundsException("Out of range: " + (length += position) + ", max = " + this.length);
        }
        System.arraycopy(this.array, position, buffer, offset, length);
    }

    @Override
    public int length() {
        return this.length;
    }
}

