/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.EmptyIterator;
import java.util.Iterator;

public class ExpandIterator<T>
implements Iterator<T> {
    private final Iterator<? extends Iterable<? extends T>> iterator;
    private Iterator<? extends T> mCurrent;

    public ExpandIterator(Iterator<? extends Iterable<? extends T>> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.getCurrent() != null;
    }

    @Override
    public T next() {
        return this.mCurrent.next();
    }

    private Iterator<? extends T> getCurrent() {
        if (this.mCurrent == null || !this.mCurrent.hasNext()) {
            this.mCurrent = null;
            while (this.iterator.hasNext()) {
                Iterator<T> item;
                Iterable<T> iterable = this.iterator.next();
                if (iterable == null || !(item = iterable.iterator()).hasNext()) continue;
                this.mCurrent = item;
                break;
            }
        }
        return this.mCurrent;
    }

    public static <T1> Iterator<T1> of(Iterator<? extends Iterable<? extends T1>> iterator) {
        if (!iterator.hasNext()) {
            return EmptyIterator.of();
        }
        return new ExpandIterator(iterator);
    }
}

