/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;

public class ComputeCollection<T, E>
implements Collection<T> {
    private final Collection<? extends E> source;
    private final Function<? super E, T> function;

    public ComputeCollection(Collection<? extends E> collection, Function<? super E, T> function) {
        this.source = collection;
        this.function = function;
    }

    public T apply(E input) {
        return this.function.apply(input);
    }

    public Collection<? extends E> getSource() {
        return this.source;
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object obj) {
        for (T item : this) {
            if (!Objects.equals(obj, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return ComputeIterator.of(this.source.iterator(), this.function);
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        if (size == 0) {
            return ArrayCollection.EMPTY_OBJECTS;
        }
        Object[] results = new Object[size];
        Iterator<E> iterator = this.source.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            results[i] = this.function.apply(iterator.next());
            ++i;
        }
        return results;
    }

    @Override
    public <T1> T1[] toArray(T1[] out) {
        if (out.length == 0) {
            return out;
        }
        int size = this.size();
        if (size == 0) {
            return out;
        }
        if (size > out.length) {
            size = out.length;
        }
        Iterator<E> iterator = this.source.iterator();
        for (int i = 0; i < size && iterator.hasNext(); ++i) {
            out[i] = this.function.apply(iterator.next());
        }
        return out;
    }

    @Override
    public boolean add(T t) {
        throw new IllegalArgumentException("Can't add on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean remove(Object o) {
        throw new IllegalArgumentException("Can't remove on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        throw new IllegalArgumentException("Can't add on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        throw new IllegalArgumentException("Can't remove on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        throw new IllegalArgumentException("Can't retain on " + this.getClass().getSimpleName());
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        throw new IllegalArgumentException("Can't clear on " + this.getClass().getSimpleName() + ", use getSource().clear();");
    }
}

