/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

public class NumbersUtil {
    public static int getUInt(int value, int start, int bitCount) {
        return value >> start - bitCount + 1 & (1 << bitCount) - 1;
    }

    public static int setUInt(int out, int value, int start, int bitCount) {
        int mask = (1 << bitCount) - 1;
        int shift = start - bitCount + 1;
        return out & ~(mask << shift) | (value &= mask) << shift;
    }

    public static int toSignedInt(int bitsCount, int unsigned) {
        if (unsigned == 0 || bitsCount <= 0) {
            return 0;
        }
        if (bitsCount > 31) {
            return unsigned;
        }
        int mask = 1 << bitsCount;
        int max = 1 << bitsCount - 1;
        if ((unsigned &= mask - 1) < max) {
            return unsigned;
        }
        return unsigned - mask;
    }

    public static long toSigned(int bitsCount, long unsigned) {
        if (unsigned == 0L || bitsCount <= 0) {
            return 0L;
        }
        if (bitsCount > 63) {
            return unsigned;
        }
        long max = 1L << bitsCount - 1;
        long mask = max << 1;
        if ((unsigned &= mask - 1L) < max) {
            return unsigned;
        }
        return unsigned - mask;
    }

    public static int minimumBitsForSigned(long num) {
        int bits = 0;
        if (num < 0L) {
            num = -num;
        } else {
            bits = 1;
        }
        long sign = 1L << (bits += NumbersUtil.countBits(num)) - 1;
        if (num > sign && bits < 64) {
            ++bits;
        }
        return bits;
    }

    public static int minimumBitsForUnSigned(long unsigned) {
        if (unsigned == 0L) {
            return 1;
        }
        return NumbersUtil.countBits(unsigned);
    }

    public static int countBits(long num) {
        int bits = 0;
        while (num != 0L) {
            num >>>= 1;
            ++bits;
        }
        return bits;
    }

    public static int minimumBytesForSigned(long num) {
        int bits = NumbersUtil.minimumBitsForSigned(num);
        int i = bits / 8;
        if ((bits & 7) != 0) {
            ++i;
        }
        return i;
    }

    public static long maxValue(int bitsCount) {
        if (bitsCount <= 0) {
            return 0L;
        }
        return (1L << bitsCount - 1) - 1L;
    }

    public static long minValue(int bitsCount) {
        if (bitsCount <= 0) {
            return 0L;
        }
        long min = 1L << bitsCount - 1;
        return -min;
    }

    public static int abs(int i) {
        if (i < 0) {
            i = -i;
        }
        return i;
    }

    public static int max(int i1, int i2) {
        if (i1 > i2) {
            return i1;
        }
        return i2;
    }

    public static int min(int i1, int i2) {
        if (i1 < i2) {
            return i1;
        }
        return i2;
    }

    public static String toBinaryString(int i) {
        StringBuilder builder = new StringBuilder(34);
        builder.append("0b");
        String b = Integer.toBinaryString(i);
        for (int rem = 32 - b.length(); rem > 0; --rem) {
            builder.append('0');
        }
        builder.append(b);
        return builder.toString();
    }
}

