/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.jcommand.utils;

import com.reandroid.jcommand.utils.SpreadSheet;

public class TwoColumnTable {
    private final SpreadSheet mSpreadSheet = new SpreadSheet();
    private String tab2 = "  ";
    private String mColumnSeparator = "   ";
    private int maxWidth = 80;
    private boolean drawBorder;

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setTab2(String tab2) {
        this.tab2 = tab2;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.mColumnSeparator = columnSeparator;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public SpreadSheet getSpreadSheet() {
        return this.mSpreadSheet;
    }

    public void clear() {
        this.getSpreadSheet().clear();
    }

    public String build() {
        return this.buildTable().toString();
    }

    public SpreadSheet buildTable() {
        SpreadSheet spreadSheet = this.getSpreadSheet();
        spreadSheet.fixColumnCount();
        spreadSheet.fitColumnWidth(0);
        int firstWidth = spreadSheet.getColumnPrintWidth(0);
        int maxWidth = this.maxWidth - firstWidth;
        if (maxWidth <= 0) {
            maxWidth = 1;
        }
        int mergedCellsWidth = spreadSheet.getMergedCellsWidth() - firstWidth;
        int width = spreadSheet.fitColumnWidth(1);
        int diff = spreadSheet.getColumnPrintWidth(1) - width;
        maxWidth -= diff;
        if (mergedCellsWidth > width) {
            width = mergedCellsWidth;
        }
        if (width > maxWidth) {
            width = maxWidth;
        }
        spreadSheet.setColumnWidth(1, width);
        return spreadSheet.format();
    }

    public SpreadSheet.Row addRow(Object item1, Object item2) {
        SpreadSheet.Row row = new SpreadSheet.Row();
        SpreadSheet.Cell cell1 = new SpreadSheet.Cell(item1);
        SpreadSheet.Cell cell2 = new SpreadSheet.Cell(item2);
        row.add(cell1);
        row.add(cell2);
        String tab2 = this.tab2;
        if (this.drawBorder) {
            tab2 = "|" + tab2;
        }
        cell1.setBorderLeft(tab2);
        cell1.setBorderRight("");
        cell2.setBorderLeft(this.mColumnSeparator);
        if (this.drawBorder) {
            cell2.setBorderRight(" |");
        } else {
            cell2.setBorderRight("");
        }
        this.mSpreadSheet.add(row);
        return row;
    }

    public boolean hasSeparatorRow() {
        SpreadSheet.Row row = this.mSpreadSheet.get(this.mSpreadSheet.size() - 1);
        if (row != null) {
            return row.get(0) instanceof SpreadSheet.SeparatorCells;
        }
        return false;
    }

    public SpreadSheet.MergedCells addMergedRow(Object item) {
        SpreadSheet.Row row = this.addRow(item, "");
        SpreadSheet.MergedCells mergedCells = row.merge(0, 2);
        mergedCells.setHorizontalIndent(0);
        mergedCells.setVerticalIndent(0);
        if (this.drawBorder) {
            mergedCells.setBorderLeft("|");
            mergedCells.setBorderRight(" |");
            mergedCells.setHorizontalIndent(1);
        }
        return mergedCells;
    }

    public SpreadSheet.MergedCells addMergedRowTabbed(Object item) {
        SpreadSheet.MergedCells mergedCells = this.addMergedRow(item);
        String tab2 = this.tab2;
        if (this.drawBorder) {
            tab2 = "|" + tab2;
        }
        mergedCells.setHorizontalIndent(0);
        mergedCells.setBorderLeft(tab2);
        return mergedCells;
    }

    public void addSeparator() {
        if (this.drawBorder && !this.hasSeparatorRow()) {
            boolean first = this.mSpreadSheet.size() == 0;
            SpreadSheet.Row row = this.addRow("", "");
            SpreadSheet.SeparatorCells mergedCells = row.asSeparator();
            mergedCells.setBorderLeft(first ? " " : "|");
            mergedCells.setBorderRight(first ? " " : "_|");
            mergedCells.setHorizontalIndent(0);
            mergedCells.setVerticalIndent(0);
        }
    }

    public void addLine() {
        if (!this.hasSeparatorRow()) {
            boolean add_vertical = this.drawBorder && this.mSpreadSheet.size() != 0;
            SpreadSheet.Row row = this.addRow("", "");
            SpreadSheet.SeparatorCells mergedCells = row.asSeparator();
            mergedCells.setBorderLeft(add_vertical ? "|" : " ");
            mergedCells.setBorderRight(add_vertical ? "_|" : " ");
            mergedCells.setHorizontalIndent(0);
            mergedCells.setVerticalIndent(0);
        }
    }
}

