/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.jcommand.utils;

import com.reandroid.jcommand.annotations.ChoiceArg;
import com.reandroid.jcommand.annotations.LastArgs;
import com.reandroid.jcommand.annotations.OptionArg;
import com.reandroid.jcommand.annotations.OtherOption;
import com.reandroid.jcommand.exceptions.CommandFormatException;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ReflectionUtil {
    public static void setCollection(Object obj, Field field, String value) {
        try {
            AbstractCollection collection = (ArrayList<Object>)field.get(obj);
            if (collection == null) {
                Class<?> type = field.getType();
                collection = ReflectionUtil.isInstanceClass(type, List.class) ? new ArrayList<Object>() : new HashSet();
                field.set(obj, collection);
            }
            Object converted = ReflectionUtil.createObject(ReflectionUtil.getCollectionEntryType(field), value);
            collection.add(converted);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object createObject(Class<?> type, String value) {
        if (type == null || String.class.equals(type)) {
            return value;
        }
        if (type.isEnum()) {
            ?[] enumConstants;
            for (Object o : enumConstants = type.getEnumConstants()) {
                Enum e = (Enum)o;
                if (!value.equalsIgnoreCase(e.name())) continue;
                return e;
            }
            throw new CommandFormatException(type, value);
        }
        if (File.class.equals(type)) {
            return new File(value);
        }
        if (Integer.class.equals(type)) {
            try {
                return Integer.decode(value);
            }
            catch (NumberFormatException e1) {
                throw new CommandFormatException(Integer.class, value);
            }
        }
        if (Long.class.equals(type)) {
            try {
                return Long.decode(value);
            }
            catch (NumberFormatException e1) {
                throw new CommandFormatException(Long.class, value);
            }
        }
        if (Double.class.equals(type)) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e1) {
                throw new CommandFormatException(Long.class, value);
            }
        }
        if (Boolean.class.equals(type)) {
            Boolean b = null;
            if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
                b = true;
            } else if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value)) {
                b = false;
            } else {
                throw new CommandFormatException(Boolean.class, value);
            }
            return b;
        }
        throw new RuntimeException("Unsupported collection entry type: " + type);
    }

    public static Class<?> getCollectionEntryType(Field field) {
        Type type = field.getAnnotatedType().getType();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] args = parameterizedType.getActualTypeArguments();
        if (args == null || args.length != 1) {
            return null;
        }
        try {
            return Class.forName(args[0].getTypeName());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static void setFile(Object obj, Field field, String value) {
        try {
            File file = new File(value);
            field.set(obj, file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setObject(Object obj, Field field, Object value) {
        try {
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setEnum(Object obj, Field field, String value) {
        ?[] enumConstants;
        Class<?> type = field.getType();
        for (Object o : enumConstants = type.getEnumConstants()) {
            Enum e = (Enum)o;
            if (!value.equalsIgnoreCase(e.name())) continue;
            ReflectionUtil.setObject(obj, field, o);
            return;
        }
        throw new CommandFormatException(type, value);
    }

    public static void setDoubleObject(Object obj, Field field, String value) {
        try {
            Double d = Double.parseDouble(value);
            field.set(obj, d);
        }
        catch (NumberFormatException e1) {
            throw new CommandFormatException(Double.class, value);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void setDouble(Object obj, Field field, String value) {
        try {
            double d = Double.parseDouble(value);
            field.setDouble(obj, d);
        }
        catch (NumberFormatException e1) {
            throw new CommandFormatException(Double.class, value);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void setLongObject(Object obj, Field field, String value) {
        try {
            Long l = Long.decode(value);
            field.set(obj, l);
        }
        catch (NumberFormatException e1) {
            throw new CommandFormatException(Long.class, value);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void setLong(Object obj, Field field, String value) {
        try {
            long l = Long.decode(value);
            field.setLong(obj, l);
        }
        catch (NumberFormatException e1) {
            throw new CommandFormatException(Long.class, value);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void setIntObject(Object obj, Field field, String value) {
        try {
            Integer i = Integer.decode(value);
            field.set(obj, i);
        }
        catch (NumberFormatException e1) {
            throw new CommandFormatException(Integer.class, value);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void setInt(Object obj, Field field, String value) {
        try {
            int i = Integer.decode(value);
            field.setInt(obj, i);
        }
        catch (NumberFormatException e1) {
            throw new CommandFormatException(Integer.class, value);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void setBooleanObject(Object obj, Field field, String value) {
        Boolean b = null;
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
            b = true;
        } else if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value)) {
            b = false;
        } else {
            throw new CommandFormatException(Boolean.class, value);
        }
        try {
            field.set(obj, b);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBoolean(Object obj, Field field, String value) {
        boolean b;
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
            b = true;
        } else if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value)) {
            b = false;
        } else {
            throw new CommandFormatException(Boolean.class, value);
        }
        ReflectionUtil.setBoolean(obj, field, b);
    }

    public static void setBoolean(Object obj, Field field, boolean value) {
        try {
            Class<?> type = field.getType();
            if (type.equals(Boolean.TYPE)) {
                field.setBoolean(obj, value);
            } else {
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> listNames(Field field) {
        ChoiceArg choiceArg;
        ArrayList<String> results = new ArrayList<String>();
        OptionArg optionArg = field.getAnnotation(OptionArg.class);
        if (optionArg != null) {
            results.add(optionArg.name());
            for (String name : optionArg.alternates()) {
                if (name == null) continue;
                results.add(name);
            }
        }
        if ((choiceArg = field.getAnnotation(ChoiceArg.class)) != null) {
            results.add(choiceArg.name());
            for (String name : choiceArg.alternates()) {
                if (name == null) continue;
                results.add(name);
            }
        }
        return results;
    }

    public static String getArgName(Field field) {
        OptionArg optionArg = field.getAnnotation(OptionArg.class);
        if (optionArg != null) {
            return optionArg.name();
        }
        ChoiceArg choiceArg = field.getAnnotation(ChoiceArg.class);
        if (choiceArg != null) {
            return choiceArg.name();
        }
        return null;
    }

    public static boolean isFlagArg(Field field) {
        OptionArg optionArg = field.getAnnotation(OptionArg.class);
        if (optionArg != null) {
            return optionArg.flag();
        }
        return false;
    }

    public static List<OptionArg> listOptionArgs(Class<?> clazz) {
        List<Field> fieldList = ReflectionUtil.listInstanceFields(clazz);
        ArrayList<OptionArg> optionArgList = new ArrayList<OptionArg>();
        for (Field field : fieldList) {
            OptionArg optionArg = field.getAnnotation(OptionArg.class);
            if (optionArg == null) continue;
            optionArgList.add(optionArg);
        }
        return optionArgList;
    }

    public static List<OtherOption> listOtherOptions(Class<?> clazz) {
        List<Method> methodList = ReflectionUtil.listMethods(clazz);
        ArrayList<OtherOption> results = new ArrayList<OtherOption>();
        for (Method method : methodList) {
            OtherOption option = method.getAnnotation(OtherOption.class);
            if (option == null) continue;
            results.add(option);
        }
        return results;
    }

    public static List<ChoiceArg> listChoiceArgs(Class<?> clazz) {
        List<Field> fieldList = ReflectionUtil.listInstanceFields(clazz);
        ArrayList<ChoiceArg> choiceArgs = new ArrayList<ChoiceArg>();
        for (Field field : fieldList) {
            ChoiceArg choiceArg = field.getAnnotation(ChoiceArg.class);
            if (choiceArg == null) continue;
            choiceArgs.add(choiceArg);
        }
        return choiceArgs;
    }

    public static LastArgs getLastArgs(Class<?> clazz) {
        List<Field> fieldList = ReflectionUtil.listInstanceFields(clazz);
        for (Field field : fieldList) {
            LastArgs lastArgs = field.getAnnotation(LastArgs.class);
            if (lastArgs == null) continue;
            return lastArgs;
        }
        return null;
    }

    public static List<Field> listInstanceFields(Class<?> clazz) {
        ArrayList<Field> results = new ArrayList<Field>();
        ReflectionUtil.listInstanceFields(clazz, results);
        return results;
    }

    private static void listInstanceFields(Class<?> clazz, List<Field> results) {
        Field[] fields;
        if (clazz == null || Object.class.equals(clazz)) {
            return;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            int mod = field.getModifiers();
            if ((mod & 8) == 8) continue;
            results.add(field);
        }
        ReflectionUtil.listInstanceFields(clazz.getSuperclass(), results);
    }

    public static List<Method> listMethods(Class<?> clazz) {
        ArrayList<Method> results = new ArrayList<Method>();
        ReflectionUtil.listMethods(clazz, results);
        return results;
    }

    private static void listMethods(Class<?> clazz, List<Method> results) {
        Method[] methods;
        if (clazz == null || Object.class.equals(clazz)) {
            return;
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (method == null) continue;
            results.add(method);
        }
        ReflectionUtil.listMethods(clazz.getSuperclass(), results);
    }

    public static <T> T createNew(Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isInstanceClass(Class<?> type, Class<?> superType) {
        Class<?>[] interfaces;
        if (type == null) {
            return false;
        }
        if (type.equals(superType)) {
            return true;
        }
        if (type.isPrimitive() || type.equals(Object.class)) {
            return false;
        }
        for (Class<?> clazz : interfaces = type.getInterfaces()) {
            if (!ReflectionUtil.isInstanceClass(clazz, superType)) continue;
            return true;
        }
        return ReflectionUtil.isInstanceClass(type.getSuperclass(), superType);
    }
}

