/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.jcommand;

import com.reandroid.jcommand.annotations.ChoiceArg;
import com.reandroid.jcommand.annotations.LastArgs;
import com.reandroid.jcommand.annotations.OptionArg;
import com.reandroid.jcommand.exceptions.DuplicateOptionException;
import com.reandroid.jcommand.exceptions.MissingValueException;
import com.reandroid.jcommand.exceptions.UnknownOptionException;
import com.reandroid.jcommand.utils.CommandUtil;
import com.reandroid.jcommand.utils.ReflectionUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubCommandParser {
    private final String[] mArgs;
    private Object mObj;
    private final Map<String, Field> optionFieldsMap;
    private final Map<String, Field> choiceOptionFieldsMap;
    private Field mLastArgs;
    private final Set<Field> mParsedFields;
    private int mIndex;

    public SubCommandParser(String[] args) {
        this.mArgs = args;
        this.optionFieldsMap = new HashMap<String, Field>();
        this.choiceOptionFieldsMap = new HashMap<String, Field>();
        this.mParsedFields = new HashSet<Field>();
    }

    public <T> T parse(Class<T> type) {
        T obj = ReflectionUtil.createNew(type);
        this.parse(obj);
        return obj;
    }

    public void parse(Object obj) {
        this.mObj = obj;
        this.mapFields(obj.getClass());
        this.parseArgs();
    }

    private void parseArgs() {
        String[] args = this.mArgs;
        int length = args.length;
        this.mIndex = 0;
        while (this.mIndex < length) {
            String arg = args[this.mIndex];
            Field field = this.optionFieldsMap.get(arg);
            if (field == null && (field = this.choiceOptionFieldsMap.get(arg)) != null) {
                this.parseChoiceOptionField(field);
            } else if (field == null) {
                if (this.mLastArgs == null) {
                    throw new UnknownOptionException(arg);
                }
                this.parseLastArgs();
            } else {
                this.parseOptionField(field);
            }
            ++this.mIndex;
        }
    }

    private void addParsed(Field field, String arg) {
        if (this.mParsedFields.contains(field)) {
            if (!ReflectionUtil.isInstanceClass(field.getType(), Collection.class)) {
                throw new DuplicateOptionException(arg);
            }
        } else {
            this.mParsedFields.add(field);
        }
    }

    private void parseOptionField(Field field) {
        OptionArg optionArg = field.getAnnotation(OptionArg.class);
        this.addParsed(field, optionArg.name());
        field.setAccessible(true);
        if (optionArg.flag()) {
            ReflectionUtil.setBoolean(this.mObj, field, true);
            return;
        }
        ++this.mIndex;
        if (this.mIndex >= this.mArgs.length) {
            throw new MissingValueException(this.mArgs[this.mIndex - 1]);
        }
        String arg = this.mArgs[this.mIndex];
        Class<?> type = field.getType();
        Object obj = this.mObj;
        if (ReflectionUtil.isInstanceClass(type, Collection.class)) {
            ReflectionUtil.setCollection(obj, field, arg);
            return;
        }
        if (type == String.class) {
            ReflectionUtil.setObject(obj, field, arg);
        } else if (type == Integer.TYPE) {
            ReflectionUtil.setInt(obj, field, arg);
        } else if (type == Integer.class) {
            ReflectionUtil.setIntObject(obj, field, arg);
        } else if (type == Long.TYPE) {
            ReflectionUtil.setLong(obj, field, arg);
        } else if (type == Long.class) {
            ReflectionUtil.setLongObject(obj, field, arg);
        } else if (type == Double.TYPE) {
            ReflectionUtil.setDouble(obj, field, arg);
        } else if (type == Double.class) {
            ReflectionUtil.setDoubleObject(obj, field, arg);
        } else if (type == Boolean.TYPE) {
            ReflectionUtil.setBoolean(obj, field, arg);
        } else if (type == Boolean.class) {
            ReflectionUtil.setBooleanObject(obj, field, arg);
        } else if (type == File.class) {
            ReflectionUtil.setFile(obj, field, arg);
        } else {
            throw new RuntimeException("Unsupported field type: " + field);
        }
    }

    private void parseChoiceOptionField(Field field) {
        ChoiceArg choiceArg = field.getAnnotation(ChoiceArg.class);
        this.addParsed(field, choiceArg.name());
        field.setAccessible(true);
        ++this.mIndex;
        if (this.mIndex >= this.mArgs.length) {
            throw new MissingValueException(this.mArgs[this.mIndex - 1]);
        }
        String arg = this.mArgs[this.mIndex];
        if (!CommandUtil.containsIgnoreCase(choiceArg.values(), arg)) {
            throw new UnknownOptionException(arg);
        }
        Class<?> type = field.getType();
        if (String.class.equals(type)) {
            ReflectionUtil.setObject(this.mObj, field, arg);
        } else if (type.isEnum()) {
            ReflectionUtil.setEnum(this.mObj, field, arg);
        } else {
            throw new RuntimeException("Unsupported choice field type: " + field);
        }
    }

    private void parseLastArgs() {
        AbstractCollection collection;
        Field field = this.mLastArgs;
        field.setAccessible(true);
        try {
            collection = (ArrayList)field.get(this.mObj);
            if (collection == null) {
                Class<?> type = field.getType();
                collection = ReflectionUtil.isInstanceClass(type, List.class) ? new ArrayList() : new HashSet();
                field.set(this.mObj, collection);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ++this.mIndex;
        while (this.mIndex < this.mArgs.length) {
            collection.add(this.mArgs[this.mIndex]);
            ++this.mIndex;
        }
    }

    private void mapFields(Class<?> type) {
        List<Field> fieldList = ReflectionUtil.listInstanceFields(type);
        Map<String, Field> optionFieldsMap = this.optionFieldsMap;
        Map<String, Field> choiceOptionFieldsMap = this.choiceOptionFieldsMap;
        for (Field field : fieldList) {
            LastArgs lastArgs;
            List<String> nameList = ReflectionUtil.listNames(field);
            for (String name : nameList) {
                Field exist = this.getField(name);
                if (exist != null) {
                    throw new RuntimeException("Duplicate fields: '" + exist + "', '" + field + "'");
                }
                if (field.getAnnotation(OptionArg.class) != null) {
                    optionFieldsMap.put(name, field);
                }
                if (field.getAnnotation(ChoiceArg.class) == null) continue;
                choiceOptionFieldsMap.put(name, field);
            }
            if (!nameList.isEmpty() || (lastArgs = field.getAnnotation(LastArgs.class)) == null) continue;
            if (this.mLastArgs != null) {
                throw new RuntimeException("Duplicate LastArgs: '" + this.mLastArgs + "', '" + field + "'");
            }
            this.mLastArgs = field;
        }
    }

    private Field getField(String name) {
        Field result = this.optionFieldsMap.get(name);
        if (result == null) {
            result = this.choiceOptionFieldsMap.get(name);
        }
        return result;
    }

    public static <T> T parse(Class<T> type, String[] args) {
        SubCommandParser parser = new SubCommandParser(args);
        return parser.parse(type);
    }

    public static void parse(Object obj, String[] args) {
        SubCommandParser parser = new SubCommandParser(args);
        parser.parse(obj);
    }
}

