/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.jcommand;

import com.reandroid.jcommand.CommandStringResource;
import com.reandroid.jcommand.CommandStrings;
import com.reandroid.jcommand.HelpBuilder;
import com.reandroid.jcommand.annotations.ChoiceArg;
import com.reandroid.jcommand.annotations.CommandOptions;
import com.reandroid.jcommand.annotations.LastArgs;
import com.reandroid.jcommand.annotations.OptionArg;
import com.reandroid.jcommand.utils.CommandUtil;
import com.reandroid.jcommand.utils.ReflectionUtil;
import com.reandroid.jcommand.utils.SpreadSheet;
import com.reandroid.jcommand.utils.TwoColumnTable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SubCommandHelpBuilder
extends HelpBuilder {
    private final CommandOptions commandOptions;
    private final List<OptionArg> optionArgList;
    private final List<ChoiceArg> choiceArgList;
    private final LastArgs lastArgs;

    public SubCommandHelpBuilder(CommandStringResource stringResource, Class<?> clazz) {
        super(stringResource);
        this.commandOptions = clazz.getAnnotation(CommandOptions.class);
        this.optionArgList = ReflectionUtil.listOptionArgs(clazz);
        this.choiceArgList = ReflectionUtil.listChoiceArgs(clazz);
        this.lastArgs = ReflectionUtil.getLastArgs(clazz);
    }

    public SubCommandHelpBuilder(Class<?> clazz) {
        this(null, clazz);
    }

    @Override
    public SpreadSheet buildTable() {
        this.reset();
        TwoColumnTable twoColumnTable = this.getTable();
        this.appendDescription();
        this.appendUsage();
        this.appendOptionArgs(this.getOptionArgList(), CommandStrings.title_options);
        this.appendChoiceArgs();
        this.appendOptionArgs(this.getFlagList(), CommandStrings.title_flags);
        this.appendExamples();
        twoColumnTable.addSeparator();
        this.appendNotes();
        twoColumnTable.addSeparator();
        return twoColumnTable.buildTable();
    }

    private void appendOptionArgs(List<OptionArg> optionArgList, String title) {
        if (optionArgList.isEmpty()) {
            return;
        }
        SubCommandHelpBuilder.sortOptionArgList(optionArgList);
        CommandStringResource stringResource = this.getStringResource();
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.addSeparator();
        twoColumnTable.addMergedRow(stringResource.getString(title));
        int length = optionArgList.size();
        for (int i = 0; i < length; ++i) {
            OptionArg optionArg = optionArgList.get(i);
            StringBuilder name = new StringBuilder();
            name.append(optionArg.name());
            for (String l : optionArg.alternates()) {
                name.append(" | ");
                name.append(l);
            }
            twoColumnTable.addRow(name.toString(), stringResource.getString(optionArg.description()));
        }
    }

    private void appendChoiceArgs() {
        List<ChoiceArg> choiceArgList = this.choiceArgList;
        if (choiceArgList.isEmpty()) {
            return;
        }
        CommandStringResource stringResource = this.getStringResource();
        TwoColumnTable twoColumnTable = this.getTable();
        if (this.optionArgList.isEmpty()) {
            twoColumnTable.addMergedRow(stringResource.getString(CommandStrings.title_options));
        }
        int length = choiceArgList.size();
        for (int i = 0; i < length; ++i) {
            ChoiceArg choiceArg = choiceArgList.get(i);
            StringBuilder name = new StringBuilder();
            name.append(choiceArg.name());
            for (String l : choiceArg.alternates()) {
                name.append(" | ");
                name.append(l);
            }
            String description = stringResource.getString(choiceArg.description()) + "\n" + CommandUtil.asString(choiceArg.values());
            twoColumnTable.addRow(name.toString(), description);
        }
    }

    private void appendExamples() {
        CommandOptions commandOptions = this.commandOptions;
        if (commandOptions == null) {
            return;
        }
        String[] examples = commandOptions.examples();
        int length = examples.length;
        if (length == 0) {
            return;
        }
        CommandStringResource stringResource = this.getStringResource();
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.addSeparator();
        twoColumnTable.addMergedRow(stringResource.getString(CommandStrings.title_example));
        for (int i = 0; i < length; ++i) {
            String col1 = i + 1 + ")  " + stringResource.getString(examples[i]);
            twoColumnTable.addMergedRowTabbed(col1);
        }
    }

    private void appendNotes() {
        CommandOptions commandOptions = this.commandOptions;
        if (commandOptions == null) {
            return;
        }
        String[] notes = commandOptions.notes();
        int length = notes.length;
        if (length == 0) {
            return;
        }
        CommandStringResource stringResource = this.getStringResource();
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.addSeparator();
        twoColumnTable.addMergedRow(stringResource.getString(CommandStrings.title_notes));
        for (int i = 0; i < length; ++i) {
            String col1 = i + 1 + ")  " + stringResource.getString(notes[i]);
            twoColumnTable.addMergedRowTabbed(col1);
        }
    }

    private void appendUsage() {
        CommandOptions options = this.commandOptions;
        if (options == null) {
            return;
        }
        String usage = options.usage();
        if (CommandUtil.isEmpty(usage)) {
            return;
        }
        CommandStringResource stringResource = this.getStringResource();
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.addSeparator();
        twoColumnTable.addMergedRow(stringResource.getString(CommandStrings.title_usage));
        twoColumnTable.addMergedRowTabbed(stringResource.getString(options.usage()));
        twoColumnTable.addSeparator();
    }

    private void appendDescription() {
        CommandStringResource stringResource = this.getStringResource();
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.addSeparator();
        CommandOptions options = this.commandOptions;
        if (options == null) {
            return;
        }
        twoColumnTable.addMergedRow(stringResource.getString(options.description()));
        twoColumnTable.addSeparator();
    }

    private List<OptionArg> getOptionArgList() {
        ArrayList<OptionArg> results = new ArrayList<OptionArg>();
        for (OptionArg optionArg : this.optionArgList) {
            if (optionArg.flag()) continue;
            results.add(optionArg);
        }
        return results;
    }

    private List<OptionArg> getFlagList() {
        ArrayList<OptionArg> results = new ArrayList<OptionArg>();
        for (OptionArg optionArg : this.optionArgList) {
            if (!optionArg.flag()) continue;
            results.add(optionArg);
        }
        return results;
    }

    private static void sortOptionArgList(List<OptionArg> optionArgList) {
        optionArgList.sort(new Comparator<OptionArg>(){

            @Override
            public int compare(OptionArg arg1, OptionArg arg2) {
                return arg1.name().compareTo(arg2.name());
            }
        });
    }
}

