/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.jcommand;

import com.reandroid.jcommand.annotations.ChoiceArg;
import com.reandroid.jcommand.annotations.LastArgs;
import com.reandroid.jcommand.annotations.OptionArg;
import com.reandroid.jcommand.utils.CommandUtil;
import com.reandroid.jcommand.utils.ReflectionUtil;
import com.reandroid.jcommand.utils.SpreadSheet;
import com.reandroid.jcommand.utils.TwoColumnTable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OptionStringBuilder {
    private final TwoColumnTable twoColumnTable;
    private final Object optionObject;
    private final List<Field> optionArgFieldsList;
    private Field mLastArgs;

    public OptionStringBuilder(Object optionObject) {
        this.optionObject = optionObject;
        this.twoColumnTable = new TwoColumnTable();
        this.optionArgFieldsList = new ArrayList<Field>();
        this.twoColumnTable.setColumnSeparator(" = ");
    }

    public void setMaxWidth(int maxWidth) {
        this.getTable().setMaxWidth(maxWidth);
    }

    public void setTab2(String tab2) {
        this.getTable().setTab2(tab2);
    }

    public void setColumnSeparator(String columnSeparator) {
        this.getTable().setColumnSeparator(columnSeparator);
    }

    public void setDrawBorder(boolean headerSeparators) {
        this.getTable().setDrawBorder(headerSeparators);
    }

    public TwoColumnTable getTable() {
        return this.twoColumnTable;
    }

    public String buildTable() {
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.clear();
        this.buildTableRows();
        twoColumnTable.getSpreadSheet().setIndent(0, 2);
        SpreadSheet spreadSheet = twoColumnTable.buildTable();
        return spreadSheet.toString();
    }

    public String buildCommandArg() {
        String[] array = this.buildArray(true);
        StringBuilder builder = new StringBuilder();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                builder.append(' ');
            }
            builder.append(array[i]);
        }
        return builder.toString();
    }

    private void buildTableRows() {
        this.listFields();
        TwoColumnTable twoColumnTable = this.getTable();
        for (Field field : this.optionArgFieldsList) {
            Object value;
            String name = ReflectionUtil.getArgName(field);
            if (name == null || (value = this.getFieldValue(field)) == null) continue;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object o : collection) {
                    if (o == null) continue;
                    twoColumnTable.addRow(name, CommandUtil.quoteString(o.toString()));
                }
                continue;
            }
            if (ReflectionUtil.isFlagArg(field) && !Boolean.TRUE.equals(value)) continue;
            twoColumnTable.addRow(name, CommandUtil.quoteString(value.toString()));
        }
        twoColumnTable.addLine();
    }

    private String[] buildArray(boolean quote) {
        this.listFields();
        ArrayList<String> results = new ArrayList<String>();
        for (Field field : this.optionArgFieldsList) {
            Object value;
            String name = ReflectionUtil.getArgName(field);
            if (name == null || (value = this.getFieldValue(field)) == null) continue;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object o : collection) {
                    if (o == null) continue;
                    String s = o.toString();
                    if (quote) {
                        s = CommandUtil.quoteString(s);
                    }
                    results.add(name);
                    results.add(s);
                }
                continue;
            }
            if (ReflectionUtil.isFlagArg(field)) {
                if (!Boolean.TRUE.equals(value)) continue;
                results.add(name);
                continue;
            }
            results.add(name);
            String s = value.toString();
            if (quote) {
                s = CommandUtil.quoteString(s);
            }
            results.add(s);
        }
        return results.toArray(new String[0]);
    }

    private Object getFieldValue(Field field) {
        try {
            field.setAccessible(true);
            return field.get(this.optionObject);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void listFields() {
        if (this.optionArgFieldsList.isEmpty() && this.mLastArgs == null) {
            this.listFields(this.optionObject.getClass());
        }
    }

    private void listFields(Class<?> type) {
        List<Field> fieldList = ReflectionUtil.listInstanceFields(type);
        for (Field field : fieldList) {
            if (field.getAnnotation(OptionArg.class) != null || field.getAnnotation(ChoiceArg.class) != null) {
                this.optionArgFieldsList.add(field);
                continue;
            }
            LastArgs lastArgs = field.getAnnotation(LastArgs.class);
            if (lastArgs == null) continue;
            this.mLastArgs = field;
        }
    }
}

