/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.NumberX;
import com.reandroid.utils.NumbersUtil;
import java.io.IOException;

public class SmaliValueX
extends SmaliValueNumber<NumberX> {
    private int width;
    private long value;

    public SmaliValueX(int width, long value) {
        this.width = width;
        this.value = value;
    }

    public SmaliValueX() {
        this(1, 0L);
    }

    public SmaliValueX(NumberX numberX) {
        this(numberX.width(), numberX.longValue());
    }

    @Override
    public DexValueType<?> getValueType() {
        return null;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(NumberX.toHexString(this.getWidth(), this.getValueAsLong()));
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        SmaliValueNumber<?> number = SmaliValueNumber.createNumber(reader);
        number.parse(reader);
        long l = number.getValueAsLong();
        int width = NumbersUtil.max(this.getWidth(), NumberX.widthOfSigned(l));
        this.set(width, l);
    }

    @Override
    public NumberX getNumber() {
        return NumberX.valueOf(this.getWidth(), this.getValueAsLong());
    }

    @Override
    public void setNumber(NumberX number) {
        this.set(number.width(), number.longValue());
    }

    public void set(int width, long value) {
        this.width = width;
        this.value = value;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public long getValueAsLong() {
        return this.value;
    }

    @Override
    public PrimitiveKey getKey() {
        return PrimitiveKey.of(this.getWidth(), this.getValueAsLong());
    }

    @Override
    public void setKey(Key key) {
        PrimitiveKey primitiveKey = (PrimitiveKey)key;
        if (!primitiveKey.isNumber()) {
            throw new NumberFormatException("Incompatible key: " + key.getClass() + ", " + key);
        }
        this.set(primitiveKey.width(), primitiveKey.getValueAsLong());
    }
}

