/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.smali.model.SmaliCode;
import com.reandroid.dex.smali.model.SmaliCodeSet;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliInstructionPayload;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliSwitchEntry;
import java.util.Iterator;

public abstract class SmaliSwitchPayload<T extends SmaliSwitchEntry>
extends SmaliInstructionPayload<T> {
    private SmaliInstruction switchInstruction;

    public SmaliSwitchPayload(SmaliInstructionOperand operand) {
        super(operand);
    }

    public abstract Opcode<?> getSwitchOpcode();

    public SmaliInstruction getSwitch() {
        SmaliInstruction switchInstruction = this.switchInstruction;
        if (switchInstruction == null) {
            this.switchInstruction = switchInstruction = this.findSwitch();
        }
        return switchInstruction;
    }

    public void setSwitch(SmaliInstruction switchInstruction) {
        this.switchInstruction = switchInstruction;
    }

    private SmaliInstruction findSwitch() {
        Opcode<?> switchOpcode = this.getSwitchOpcode();
        SmaliCodeSet codeSet = this.getCodeSet();
        if (codeSet != null) {
            int address = this.getAddress();
            int index = codeSet.indexOf(this) - 1;
            Iterator iterator = codeSet.reversedIterator(index);
            while (iterator.hasNext()) {
                SmaliCode smaliCode = (SmaliCode)iterator.next();
                if (!(smaliCode instanceof SmaliLabel)) {
                    return null;
                }
                SmaliLabel label = (SmaliLabel)smaliCode;
                if (address != label.getAddress()) continue;
                Iterator<SmaliInstruction> instructions = codeSet.getInstructions(label);
                while (instructions.hasNext()) {
                    SmaliInstruction instruction = instructions.next();
                    if (switchOpcode != instruction.getOpcode()) continue;
                    return instruction;
                }
            }
        }
        return null;
    }
}

