/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.ins.InsArrayData;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliInstructionPayload;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.dex.smali.model.SmaliValueX;
import java.io.IOException;
import java.util.Iterator;

public class SmaliPayloadArray
extends SmaliInstructionPayload<SmaliValueX> {
    public SmaliPayloadArray() {
        super(new SmaliInstructionOperand.SmaliDecimalOperand());
    }

    public void addEntryKeys(Iterator<PrimitiveKey> iterator) {
        while (iterator.hasNext()) {
            this.addEntry(iterator.next());
        }
    }

    @Override
    public void addEntry(PrimitiveKey key) {
        ((SmaliValueX)this.newEntry()).setKey(key);
    }

    public long[] getValuesAsLong() {
        SmaliSet entries = this.getEntries();
        int size = entries.size();
        long[] result = new long[size];
        for (int i = 0; i < size; ++i) {
            result[i] = ((SmaliValueX)entries.get(i)).getValueAsLong();
        }
        return result;
    }

    @Override
    public SmaliInstructionOperand.SmaliDecimalOperand getOperand() {
        return (SmaliInstructionOperand.SmaliDecimalOperand)super.getOperand();
    }

    public int getWidth() {
        return this.getOperand().getNumber();
    }

    public void setWidth(int width) {
        this.getOperand().setNumber(width);
        SmaliSet entries = this.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            ((SmaliValueX)entries.get(i)).setWidth(width);
        }
    }

    @Override
    public int getCodeUnits() {
        int count = this.getCount();
        int width = this.getWidth();
        int size = 8 + width * count;
        int align = (2 - size % 2) % 2;
        return (size += align) / 2;
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.ARRAY_DATA;
    }

    @Override
    public Opcode<InsArrayData> getOpcode() {
        return Opcode.ARRAY_PAYLOAD;
    }

    @Override
    SmaliValueX createEntry() {
        SmaliValueX value = new SmaliValueX();
        value.setWidth(this.getWidth());
        return value;
    }

    @Override
    void parseOperand(Opcode<?> opcode, SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        int position = reader.position();
        SmaliInstructionOperand.SmaliDecimalOperand operand = this.getOperand();
        operand.parse(opcode, reader);
        int width = operand.getNumber();
        if (width < 0 || width > 8) {
            reader.position(position);
            throw new SmaliParseException("Array width out of range (0 .. 8) : '" + width + "'", reader);
        }
    }
}

