/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.program.MethodProgram;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliDefSet;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.util.Iterator;

public class SmaliMethodSet
extends SmaliDefSet<SmaliMethod> {
    public Iterator<SmaliMethod> getDirectMethods() {
        return FilterIterator.of(this.iterator(), MethodProgram::isDirect);
    }

    public Iterator<SmaliMethod> getVirtualMethods() {
        return FilterIterator.of(this.iterator(), MethodProgram::isVirtual);
    }

    @Override
    SmaliMethod createNew() {
        return new SmaliMethod();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.METHOD;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        boolean appendOnce = false;
        Iterator<SmaliMethod> iterator = this.getDirectMethods();
        while (iterator.hasNext()) {
            writer.newLineDouble();
            if (!appendOnce) {
                writer.appendComment("direct methods");
                writer.newLine();
            }
            iterator.next().append(writer);
            appendOnce = true;
        }
        appendOnce = false;
        iterator = this.getVirtualMethods();
        while (iterator.hasNext()) {
            writer.newLineDouble();
            if (!appendOnce) {
                writer.appendComment("virtual methods");
                writer.newLine();
            }
            iterator.next().append(writer);
            appendOnce = true;
        }
    }

    public static SmaliMethodSet read(SmaliReader reader) throws IOException {
        SmaliMethodSet smali = new SmaliMethodSet();
        smali.parse(reader);
        if (!smali.isEmpty()) {
            return smali;
        }
        return null;
    }
}

