/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.MethodParameterProgram;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationSet;
import com.reandroid.dex.smali.model.SmaliDebug;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.dex.smali.model.SmaliRegister;
import com.reandroid.dex.smali.model.SmaliRegisterSet;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;

public class SmaliMethodParameter
extends SmaliDebug
implements MethodParameterProgram,
SmaliRegion {
    private final SmaliRegisterSet registerSet = new SmaliRegisterSet();
    private StringKey name;
    private SmaliAnnotationSet annotationSet;

    @Override
    public TypeKey getKey() {
        SmaliMethod smaliMethod = this.getParentInstance(SmaliMethod.class);
        if (smaliMethod == null) {
            return null;
        }
        ProtoKey protoKey = smaliMethod.getProtoKey();
        if (protoKey == null) {
            return null;
        }
        SmaliRegister smaliRegister = this.getSmaliRegister();
        if (smaliRegister == null) {
            return null;
        }
        int index = smaliRegister.getNumber();
        if (!smaliMethod.isStatic()) {
            --index;
        }
        return protoKey.getParameter(protoKey.getParameterIndex(index));
    }

    public SmaliRegister getSmaliRegister() {
        SmaliRegisterSet registerSet = this.getRegisterSet();
        if (registerSet.isEmpty()) {
            return null;
        }
        return (SmaliRegister)registerSet.get(0);
    }

    SmaliRegisterSet getRegisterSet() {
        return this.registerSet;
    }

    public StringKey getNameKey() {
        return this.name;
    }

    public void setName(StringKey name) {
        this.name = name;
    }

    @Override
    public String getDebugName() {
        StringKey key = this.getNameKey();
        if (key != null) {
            return key.getString();
        }
        return null;
    }

    @Override
    public void setDebugName(String name) {
        if (StringsUtil.isEmpty(name)) {
            name = null;
        }
        StringKey key = name == null ? null : StringKey.create(name);
        this.setName(key);
    }

    @Override
    public AnnotationSetKey getAnnotation() {
        SmaliAnnotationSet annotationSet = this.getSmaliAnnotationSet();
        if (annotationSet != null) {
            return annotationSet.getKey();
        }
        return AnnotationSetKey.empty();
    }

    @Override
    public void setAnnotation(AnnotationSetKey annotation) {
        if (annotation == null || annotation.isEmpty()) {
            this.setSmaliAnnotationSet(null);
        } else {
            this.getOrCreateSmaliAnnotationSet().setKey(annotation);
        }
    }

    @Override
    public void clearAnnotations() {
        this.setSmaliAnnotationSet(null);
    }

    public SmaliAnnotationSet getSmaliAnnotationSet() {
        return this.annotationSet;
    }

    public SmaliAnnotationSet getOrCreateSmaliAnnotationSet() {
        SmaliAnnotationSet annotationSet = this.getSmaliAnnotationSet();
        if (annotationSet == null) {
            annotationSet = new SmaliAnnotationSet();
            this.setSmaliAnnotationSet(annotationSet);
        }
        return annotationSet;
    }

    public void setSmaliAnnotationSet(SmaliAnnotationSet annotationSet) {
        this.annotationSet = annotationSet;
        if (annotationSet != null) {
            annotationSet.setParent(this);
        }
    }

    public int getDefinitionIndex() {
        SmaliMethod smaliMethod = this.getParentInstance(SmaliMethod.class);
        if (smaliMethod == null) {
            return -1;
        }
        ProtoKey protoKey = smaliMethod.getProtoKey();
        if (protoKey == null) {
            return -1;
        }
        SmaliRegister smaliRegister = this.getSmaliRegister();
        if (smaliRegister == null) {
            return -1;
        }
        int index = smaliRegister.getNumber();
        if (!smaliMethod.isStatic()) {
            --index;
        }
        return protoKey.getParameterIndex(index);
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.PARAM;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        SmaliAnnotationSet annotationSet;
        SmaliDirective directive = this.getSmaliDirective();
        directive.append(writer);
        this.getRegisterSet().append(writer);
        StringKey name = this.getNameKey();
        if (name != null) {
            writer.append(", ");
            name.append(writer);
        }
        if ((annotationSet = this.getSmaliAnnotationSet()) != null) {
            writer.indentPlus();
            writer.newLine();
            annotationSet.append(writer);
            writer.indentMinus();
            directive.appendEnd(writer);
        }
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        super.parse(reader);
        this.getRegisterSet().parse(reader);
        reader.skipWhitespacesOrComment();
        if (reader.get() == 44) {
            reader.skip(1);
            reader.skipWhitespacesOrComment();
        }
        this.parseName(reader);
        this.parseAnnotationSet(reader);
        AnnotationItemKey duplicate = (AnnotationItemKey)this.getAnnotation().getDuplicate();
        if (duplicate != null) {
            throw new SmaliParseException("Multiple annotation of type: " + duplicate.getType() + "\n", reader);
        }
    }

    private void parseName(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        if (reader.get() == 34) {
            this.setName(StringKey.read(reader));
        }
    }

    private void parseAnnotationSet(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive != SmaliDirective.ANNOTATION) {
            return;
        }
        int position = reader.position();
        SmaliAnnotationSet annotationSet = new SmaliAnnotationSet();
        annotationSet.parse(reader);
        reader.skipWhitespacesOrComment();
        if (this.getSmaliDirective().isEnd(reader)) {
            this.setSmaliAnnotationSet(annotationSet);
            SmaliDirective.parse(reader);
        } else {
            reader.position(position);
        }
    }
}

