/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.base.DexException;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCode;
import com.reandroid.dex.smali.model.SmaliCodeSet;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class SmaliLabel
extends SmaliCode {
    private String labelName;

    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String labelName) {
        if (labelName.charAt(0) == ':') {
            labelName = labelName.substring(1);
        }
        this.setLabelNameInternal(labelName);
    }

    private void setLabelNameInternal(String labelName) {
        this.labelName = labelName;
    }

    public int getIntegerData() {
        int address = this.getAddress();
        if (address == -1) {
            throw new DexException("Missing target label '" + this.getLabelName() + "'" + this.buildOrigin());
        }
        return address;
    }

    public int getAddress() {
        return this.searchAddress();
    }

    private int searchAddress() {
        SmaliCodeSet codeSet = this.getCodeSet();
        if (codeSet == null) {
            return -1;
        }
        if (codeSet != this.getParent()) {
            int i = codeSet.indexOf(this);
            if (i < 0) {
                return -1;
            }
            SmaliLabel label = (SmaliLabel)codeSet.get(i);
            return label.getAddress();
        }
        Iterator<SmaliInstruction> iterator = codeSet.iterator(codeSet.indexOf(this) + 1, SmaliInstruction.class);
        if (iterator.hasNext()) {
            return iterator.next().getAddress();
        }
        SmaliInstruction nullInstruction = codeSet.getNullInstruction();
        if (nullInstruction != null) {
            return nullInstruction.getAddress();
        }
        return -1;
    }

    public SmaliInstruction getTargetInstruction() {
        SmaliCodeSet codeSet = this.getCodeSet();
        if (codeSet == null) {
            return null;
        }
        int i = codeSet.indexOf(this);
        if (i < 0) {
            return null;
        }
        SmaliInstruction instruction = CollectionUtil.getFirst(codeSet.iterator(i + 1, SmaliInstruction.class));
        if (instruction == null) {
            instruction = codeSet.getNullInstruction();
        }
        return instruction;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(':');
        writer.append(this.getLabelName());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespaces();
        this.setOrigin(reader.getCurrentOrigin());
        SmaliParseException.expect(reader, ':');
        int i1 = reader.indexOfWhiteSpaceOrComment();
        int i2 = reader.indexOfBeforeLineEnd('}');
        int i = i2 >= 0 && i2 < i1 ? i2 : i1;
        int length = i - reader.position();
        this.setLabelNameInternal(reader.readString(length));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SmaliLabel)) {
            return false;
        }
        SmaliLabel other = (SmaliLabel)obj;
        return ObjectsUtil.equals(this.getLabelName(), other.getLabelName());
    }

    public int hashCode() {
        return Objects.hash(this.getLabelName());
    }
}

