/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.OperandType;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.CallSiteKey;
import com.reandroid.dex.key.DualKeyReference;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliValueInteger;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;

public abstract class SmaliInstructionOperand
extends Smali {
    public static final SmaliInstructionOperand NO_OPERAND = new SmaliInstructionOperand(){

        @Override
        public long getValueAsLong() {
            return -1L;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public void append(SmaliWriter writer) {
        }

        @Override
        public void parse(Opcode<?> opcode, SmaliReader reader) {
            reader.skipSpaces();
        }

        @Override
        void setParent(Smali parent) {
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return super.hashCode();
        }
    };

    public abstract long getValueAsLong();

    public abstract OperandType getOperandType();

    @Override
    public abstract void append(SmaliWriter var1) throws IOException;

    @Override
    public final void parse(SmaliReader reader) throws IOException {
        throw new RuntimeException("Must call parse(Opcode, SmaliReader)");
    }

    public abstract void parse(Opcode<?> var1, SmaliReader var2) throws IOException;

    public static class SmaliDualKeyOperand
    extends SmaliKeyOperand
    implements DualKeyReference {
        private Key key2;

        @Override
        public Key getKey2() {
            return this.key2;
        }

        @Override
        public void setKey2(Key key) {
            this.key2 = key;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.DUAL_KEY;
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            super.append(writer);
            writer.append(", ");
            Key key = this.getKey2();
            if (key != null) {
                key.append(writer);
            }
        }

        @Override
        public void parse(Opcode<?> opcode, SmaliReader reader) throws IOException {
            super.parse(opcode, reader);
            reader.skipWhitespaces();
            SmaliParseException.expect(reader, ',');
            reader.skipWhitespaces();
            this.setKey2(this.parseKey(opcode.getSectionType2(), reader));
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SmaliDualKeyOperand other = (SmaliDualKeyOperand)obj;
            return ObjectsUtil.equals(this.getKey(), other.getKey()) && ObjectsUtil.equals(this.getKey2(), other.getKey2());
        }

        @Override
        public int hashCode() {
            return ObjectsUtil.hash(this.getKey(), this.getKey2());
        }
    }

    public static class SmaliKeyOperand
    extends SmaliInstructionOperand
    implements KeyReference {
        private Key key;

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public void setKey(Key key) {
            this.key = key;
        }

        @Override
        public long getValueAsLong() {
            return -1L;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            Key key = this.getKey();
            if (key != null) {
                key.append(writer);
            }
        }

        @Override
        public void parse(Opcode<?> opcode, SmaliReader reader) throws IOException {
            this.setKey(this.parseKey(opcode.getSectionType(), reader));
        }

        Key parseKey(SectionType<?> sectionType, SmaliReader reader) throws IOException {
            Key key;
            if (sectionType == SectionType.STRING_ID) {
                key = StringKey.read(reader);
            } else if (sectionType == SectionType.TYPE_ID) {
                key = TypeKey.read(reader);
            } else if (sectionType == SectionType.FIELD_ID) {
                key = FieldKey.read(reader);
            } else if (sectionType == SectionType.PROTO_ID) {
                key = ProtoKey.read(reader);
            } else if (sectionType == SectionType.METHOD_ID) {
                key = MethodKey.read(reader);
            } else if (sectionType == SectionType.CALL_SITE_ID) {
                key = CallSiteKey.read(reader);
            } else {
                throw new SmaliParseException("Invalid key", reader);
            }
            return key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SmaliKeyOperand other = (SmaliKeyOperand)obj;
            return ObjectsUtil.equals(this.getKey(), other.getKey());
        }

        public int hashCode() {
            return ObjectsUtil.hash(this.getKey());
        }
    }

    public static class SmaliDecimalOperand
    extends SmaliInstructionOperand {
        private int number;

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        @Override
        public long getValueAsLong() {
            return this.number;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.DECIMAL;
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.appendInteger(this.getNumber());
        }

        @Override
        public void parse(Opcode<?> opcode, SmaliReader reader) throws IOException {
            reader.skipSpaces();
            this.setNumber(reader.readInteger());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SmaliDecimalOperand other = (SmaliDecimalOperand)obj;
            return this.getNumber() == other.getNumber();
        }

        public int hashCode() {
            return 31 + this.getNumber();
        }
    }

    public static class SmaliHexOperand
    extends SmaliInstructionOperand {
        private SmaliValueNumber<?> valueNumber = new SmaliValueInteger();

        public void setNumber(Number number) {
            this.setNumberValue(SmaliValueNumber.createFor(number));
        }

        public SmaliValueNumber<?> getValueNumber() {
            return this.valueNumber;
        }

        public void setNumberValue(SmaliValueNumber<?> valueNumber) {
            this.valueNumber = valueNumber;
            if (valueNumber != null) {
                valueNumber.setParent(this);
            }
        }

        @Override
        public long getValueAsLong() {
            return this.getValueNumber().getValueAsLong();
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.appendOptional(this.getValueNumber());
        }

        @Override
        public void parse(Opcode<?> opcode, SmaliReader reader) throws IOException {
            reader.skipSpaces();
            SmaliValueNumber<?> value = SmaliValueNumber.createNumber(reader);
            this.setNumberValue(value);
            value.parse(reader);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SmaliHexOperand other = (SmaliHexOperand)obj;
            return ObjectsUtil.equals(this.getValueNumber(), other.getValueNumber());
        }

        public int hashCode() {
            return ObjectsUtil.hash(this.getValueNumber());
        }
    }

    public static class SmaliLabelOperand
    extends SmaliInstructionOperand {
        private final SmaliLabel label = new SmaliLabel();

        public SmaliLabelOperand() {
            this.label.setParent(this);
        }

        public SmaliLabel getLabel() {
            return this.label;
        }

        @Override
        public long getValueAsLong() {
            return this.getLabel().getIntegerData();
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.LABEL;
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            this.getLabel().append(writer);
        }

        @Override
        public void parse(Opcode<?> opcode, SmaliReader reader) throws IOException {
            this.getLabel().parse(reader);
        }
    }
}

