/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.dex.smali.model.SmaliDef;
import com.reandroid.dex.smali.model.SmaliSet;
import java.io.IOException;

public abstract class SmaliDefSet<T extends SmaliDef>
extends SmaliSet<T>
implements SmaliRegion {
    private TypeKey defining;

    public TypeKey getDefining() {
        SmaliClass smaliClass;
        TypeKey typeKey = this.defining;
        if (typeKey == null && (smaliClass = this.getSmaliClass()) != null) {
            typeKey = smaliClass.getKey();
        }
        return typeKey;
    }

    public void setDefining(TypeKey defining) {
        this.defining = defining;
    }

    abstract T createNew();

    public SmaliClass getSmaliClass() {
        return this.getParentInstance(SmaliClass.class);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendAllWithDoubleNewLine(this.iterator());
    }

    @Override
    T createNext(SmaliReader reader) {
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive != this.getSmaliDirective()) {
            return null;
        }
        return this.createNew();
    }
}

