/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.HiddenApiFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.ProgramKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.AccessibleProgram;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliAnnotationSet;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.dex.smali.model.SmaliDefSet;
import com.reandroid.utils.collection.CombiningIterator;
import java.util.Iterator;

public abstract class SmaliDef
extends Smali
implements AccessibleProgram,
SmaliRegion {
    private StringKey name;
    private int accessFlagsValue;
    private int hiddenApiFlagsValue = HiddenApiFlag.NO_RESTRICTION;
    private SmaliAnnotationSet annotation;
    private TypeKey defining;

    @Override
    public abstract ProgramKey getKey();

    @Override
    public int getAccessFlagsValue() {
        return this.accessFlagsValue;
    }

    @Override
    public void setAccessFlagsValue(int accessFlagsValue) {
        this.accessFlagsValue = accessFlagsValue;
    }

    public int getHiddenApiFlagsValue() {
        return this.hiddenApiFlagsValue;
    }

    public void setHiddenApiFlagsValue(int hiddenApiFlagsValue) {
        this.hiddenApiFlagsValue = hiddenApiFlagsValue;
    }

    @Override
    public AnnotationSetKey getAnnotation() {
        SmaliAnnotationSet annotationSet = this.getAnnotationSet();
        if (annotationSet != null) {
            return annotationSet.getKey();
        }
        return AnnotationSetKey.empty();
    }

    @Override
    public void setAnnotation(AnnotationSetKey annotation) {
        if (annotation == null || annotation.isEmpty()) {
            this.setSmaliAnnotationSet(null);
        } else {
            this.getOrCreateSmaliAnnotationSet().setKey(annotation);
        }
    }

    @Override
    public boolean hasAnnotations() {
        SmaliAnnotationSet annotationSet = this.getAnnotationSet();
        return annotationSet != null && !annotationSet.isEmpty();
    }

    @Override
    public void clearAnnotations() {
        this.setSmaliAnnotationSet(null);
    }

    public void setAccessFlags(AccessFlag[] accessFlags) {
        this.setAccessFlagsValue(Modifier.combineValues(accessFlags));
    }

    public void setAccessFlags(Iterator<AccessFlag> iterator) {
        this.setAccessFlagsValue(AccessFlag.combineAccessFlags(iterator));
    }

    public Iterator<HiddenApiFlag> getHiddenApiFlags() {
        return HiddenApiFlag.valuesOf(this.getHiddenApiFlagsValue());
    }

    public void setHiddenApiFlags(HiddenApiFlag ... flags) {
        this.setHiddenApiFlagsValue(HiddenApiFlag.combineHiddenApiFlag(flags));
    }

    public void setHiddenApiFlags(Iterator<HiddenApiFlag> iterator) {
        this.setHiddenApiFlagsValue(HiddenApiFlag.combineHiddenApiFlag(iterator));
    }

    @Override
    public Iterator<? extends Modifier> getModifiers() {
        return CombiningIterator.two(this.getAccessFlags(), this.getHiddenApiFlags());
    }

    public StringKey getNameKey() {
        return this.name;
    }

    public String getName() {
        StringKey name = this.getNameKey();
        if (name != null) {
            return name.getString();
        }
        return null;
    }

    public void setName(StringKey name) {
        this.name = name;
    }

    public void setName(String name) {
        this.setName(StringKey.create(name));
    }

    public TypeKey getDefining() {
        TypeKey typeKey = null;
        SmaliDefSet<?> defSet = this.getDefSet();
        if (defSet != null) {
            typeKey = defSet.getDefining();
        }
        if (typeKey == null) {
            typeKey = this.defining;
        }
        return typeKey;
    }

    public void setDefining(TypeKey defining) {
        this.defining = defining;
    }

    public AnnotationSetKey getAnnotationSetKey() {
        SmaliAnnotationSet annotationSet = this.getAnnotationSet();
        if (annotationSet != null) {
            return annotationSet.getKey();
        }
        return null;
    }

    public void setAnnotation(Iterator<AnnotationItemKey> iterator) {
        if (iterator.hasNext()) {
            this.getOrCreateSmaliAnnotationSet().addAnnotations(iterator);
        } else {
            this.setSmaliAnnotationSet(null);
        }
    }

    @Override
    public void addAnnotation(AnnotationItemKey annotation) {
        SmaliAnnotationSet annotationSet = this.getOrCreateSmaliAnnotationSet();
        annotationSet.addAnnotation(annotation);
    }

    public SmaliAnnotationSet getAnnotationSet() {
        return this.annotation;
    }

    public SmaliAnnotationSet getOrCreateSmaliAnnotationSet() {
        SmaliAnnotationSet directory = this.getAnnotationSet();
        if (directory == null) {
            directory = new SmaliAnnotationSet();
            this.setSmaliAnnotationSet(directory);
        }
        return directory;
    }

    public void setSmaliAnnotationSet(SmaliAnnotationSet annotation) {
        SmaliAnnotationSet old = this.annotation;
        this.annotation = annotation;
        if (annotation != null) {
            annotation.setParent(this);
        }
        if (old != null && old != annotation) {
            old.setParent(null);
        }
    }

    public boolean hasAnnotation() {
        SmaliAnnotationSet annotation = this.getAnnotationSet();
        return annotation != null && !annotation.isEmpty();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return null;
    }

    private SmaliDefSet<?> getDefSet() {
        return this.getParentInstance(SmaliDefSet.class);
    }

    public SmaliClass getSmaliClass() {
        if (this.getClass().isInstance(SmaliClass.class)) {
            return (SmaliClass)this;
        }
        return this.getParentInstance(SmaliClass.class);
    }
}

