/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.formatters;

import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.formatters.SmaliComment;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;

public interface MethodComment
extends SmaliComment {
    public void writeComment(SmaliWriter var1, MethodKey var2) throws IOException;

    public static class MethodImplementComment
    implements MethodComment {
        private final DexClassRepository classRepository;

        public MethodImplementComment(DexClassRepository classRepository) {
            this.classRepository = classRepository;
        }

        @Override
        public void writeComment(SmaliWriter writer, MethodKey methodKey) throws IOException {
            DexMethod dexMethod = this.classRepository.getDeclaredMethod(methodKey);
            if (dexMethod != null && !dexMethod.isDirect() && !dexMethod.getDexClass().isFinal()) {
                SmaliComment.writeDeclarationComment(writer, "implemented-by:", dexMethod.getOverriding());
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MethodImplementComment)) {
                return false;
            }
            MethodImplementComment that = (MethodImplementComment)obj;
            return this.classRepository == that.classRepository;
        }

        public int hashCode() {
            return ObjectsUtil.hash(this.classRepository, this.getClass());
        }
    }

    public static class MethodOverrideComment
    implements MethodComment {
        private final DexClassRepository classRepository;

        public MethodOverrideComment(DexClassRepository classRepository) {
            this.classRepository = classRepository;
        }

        @Override
        public void writeComment(SmaliWriter writer, MethodKey methodKey) throws IOException {
            DexMethod superMethod;
            DexMethod dexMethod = this.classRepository.getDeclaredMethod(methodKey);
            if (dexMethod != null && !dexMethod.isDirect() && (superMethod = dexMethod.getSuperMethod()) != null) {
                SmaliComment.writeDeclarationComment(writer, "overrides:", SingleIterator.of(superMethod));
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MethodOverrideComment)) {
                return false;
            }
            MethodOverrideComment that = (MethodOverrideComment)obj;
            return this.classRepository == that.classRepository;
        }

        public int hashCode() {
            return ObjectsUtil.hash(this.classRepository, this.getClass());
        }
    }
}

