/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.smali.SmaliFileNameFactory;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.formatters.ClassComment;
import com.reandroid.dex.smali.formatters.MethodComment;
import com.reandroid.dex.smali.formatters.ResourceIdComment;
import com.reandroid.utils.collection.ArrayCollection;
import java.io.IOException;
import java.util.List;

public class SmaliWriterSetting {
    private SmaliFileNameFactory fileNameFactory;
    private ResourceIdComment resourceIdComment;
    private List<MethodComment> methodCommentList;
    private List<ClassComment> classCommentList;
    private boolean sequentialLabel = true;
    private boolean commentUnicodeStrings = false;
    private boolean localRegistersCount = true;
    private int maximumCommentLines = 500;

    public SmaliFileNameFactory getFileNameFactory() {
        SmaliFileNameFactory factory = this.fileNameFactory;
        if (factory == null) {
            this.fileNameFactory = factory = SmaliFileNameFactory.newInstance();
        }
        return factory;
    }

    public void setFileNameFactory(SmaliFileNameFactory fileNameFactory) {
        this.fileNameFactory = fileNameFactory;
    }

    public boolean isSequentialLabel() {
        return this.sequentialLabel;
    }

    public void setSequentialLabel(boolean sequentialLabel) {
        this.sequentialLabel = sequentialLabel;
    }

    public boolean isCommentUnicodeStrings() {
        return this.commentUnicodeStrings;
    }

    public void setCommentUnicodeStrings(boolean commentUnicodeStrings) {
        this.commentUnicodeStrings = commentUnicodeStrings;
    }

    public boolean isLocalRegistersCount() {
        return this.localRegistersCount;
    }

    public void setLocalRegistersCount(boolean localRegistersCount) {
        this.localRegistersCount = localRegistersCount;
    }

    public int getMaximumCommentLines() {
        return this.maximumCommentLines;
    }

    public void setMaximumCommentLines(int maximumCommentLines) {
        this.maximumCommentLines = maximumCommentLines;
    }

    public void writeResourceIdComment(SmaliWriter writer, long l) throws IOException {
        ResourceIdComment resourceIdComment = this.getResourceIdComment();
        if (resourceIdComment != null) {
            resourceIdComment.writeComment(writer, (int)l);
        }
    }

    public void writeResourceIdComment(SmaliWriter writer, int i) throws IOException {
        ResourceIdComment resourceIdComment = this.getResourceIdComment();
        if (resourceIdComment != null) {
            resourceIdComment.writeComment(writer, i);
        }
    }

    public ResourceIdComment getResourceIdComment() {
        return this.resourceIdComment;
    }

    public void setResourceIdComment(ResourceIdComment resourceIdComment) {
        this.resourceIdComment = resourceIdComment;
    }

    public void setResourceIdComment(PackageBlock packageBlock) {
        this.setResourceIdComment(new ResourceIdComment.ResourceTableComment(packageBlock));
    }

    public void writeMethodComment(SmaliWriter writer, MethodKey methodKey) throws IOException {
        List<MethodComment> methodCommentList = this.getMethodCommentList();
        if (methodCommentList != null) {
            for (MethodComment methodComment : methodCommentList) {
                methodComment.writeComment(writer, methodKey);
            }
        }
    }

    public List<MethodComment> getMethodCommentList() {
        return this.methodCommentList;
    }

    public void clearMethodComments() {
        List<MethodComment> commentList = this.methodCommentList;
        if (commentList != null) {
            commentList.clear();
        }
    }

    public void addMethodComment(MethodComment methodComment) {
        if (methodComment == null) {
            return;
        }
        List<MethodComment> commentList = this.methodCommentList;
        if (commentList == null) {
            this.methodCommentList = commentList = new ArrayCollection<MethodComment>();
        }
        if (!commentList.contains(methodComment)) {
            commentList.add(methodComment);
        }
    }

    public void addMethodComments(DexClassRepository classRepository) {
        this.addMethodComment(new MethodComment.MethodOverrideComment(classRepository));
        this.addMethodComment(new MethodComment.MethodImplementComment(classRepository));
    }

    public void writeClassComment(SmaliWriter writer, TypeKey typeKey) throws IOException {
        List<ClassComment> commentList = this.getClassCommentList();
        if (commentList != null) {
            for (ClassComment comment : commentList) {
                comment.writeComment(writer, typeKey);
            }
        }
    }

    public List<ClassComment> getClassCommentList() {
        return this.classCommentList;
    }

    public void clearClassComments() {
        List<ClassComment> commentList = this.classCommentList;
        if (commentList != null) {
            commentList.clear();
        }
    }

    public void addClassComment(ClassComment classComment) {
        if (classComment == null) {
            return;
        }
        List<ClassComment> commentList = this.classCommentList;
        if (commentList == null) {
            this.classCommentList = commentList = new ArrayCollection<ClassComment>();
        }
        if (!commentList.contains(classComment)) {
            commentList.add(classComment);
        }
    }

    public void addClassComments(DexClassRepository classRepository) {
        this.addClassComment(new ClassComment.ClassExtendComment(classRepository));
        this.addClassComment(new ClassComment.ClassImplementComment(classRepository));
    }
}

