/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.common.BytesOutputStream;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.header.DexHeader;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.sections.DexContainerBlock;
import com.reandroid.dex.sections.MapList;
import com.reandroid.dex.sections.Marker;
import com.reandroid.dex.sections.MergeOptions;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.MultiMap;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.function.Predicate;

public class DexLayoutBlock
extends FixedBlockContainer
implements FullRefresh {
    private final SectionList sectionList = new SectionList();
    private final MultiMap<TypeKey, ClassId> extendingClassMap;
    private final MultiMap<TypeKey, ClassId> interfaceMap;
    private Object mTag;

    public DexLayoutBlock() {
        super(1);
        this.addChild(0, this.sectionList);
        this.extendingClassMap = new MultiMap();
        this.interfaceMap = new MultiMap();
    }

    public int getVersion() {
        return this.getHeader().getVersion();
    }

    public void setVersion(int version) {
        this.getHeader().setVersion(version);
    }

    public Iterator<Marker> getMarkers() {
        return Marker.parse(this.getSection(SectionType.STRING_ID));
    }

    public Iterator<ClassId> getExtendingOrImplementing(TypeKey typeKey) {
        Iterator<ClassId> iterator = CombiningIterator.two(this.getExtendingClassIds(typeKey), this.getImplementationIds(typeKey));
        return new IterableIterator<ClassId, ClassId>(iterator){

            @Override
            public Iterator<ClassId> iterator(ClassId element) {
                return CombiningIterator.singleOne(element, DexLayoutBlock.this.getExtendingOrImplementing(element.getKey()));
            }
        };
    }

    public Iterator<ClassId> getExtendingClassIds(TypeKey typeKey) {
        if (this.extendingClassMap.size() == 0) {
            this.loadExtendingClassMap();
        }
        return this.extendingClassMap.getAll(typeKey);
    }

    public Iterator<ClassId> getImplementationIds(TypeKey interfaceClass) {
        if (this.interfaceMap.size() == 0) {
            this.loadInterfacesMap();
        }
        return this.interfaceMap.getAll(interfaceClass);
    }

    public void clear() {
        this.extendingClassMap.clear();
        this.interfaceMap.clear();
        this.getSectionList().clear();
    }

    private void loadExtendingClassMap() {
        MultiMap<TypeKey, ClassId> superClassMap = this.extendingClassMap;
        superClassMap.clear();
        Section<ClassId> section = this.getSectionList().getSection(SectionType.CLASS_ID);
        if (section == null) {
            return;
        }
        superClassMap.setInitialSize(section.getCount());
        for (ClassId classId : section) {
            TypeKey typeKey = classId.getSuperClassKey();
            if (DexUtils.isJavaFramework(typeKey.getTypeName())) continue;
            superClassMap.put(typeKey, classId);
        }
    }

    private void loadInterfacesMap() {
        MultiMap<TypeKey, ClassId> interfaceMap = this.interfaceMap;
        interfaceMap.clear();
        Section<ClassId> section = this.getSectionList().getSection(SectionType.CLASS_ID);
        if (section == null) {
            return;
        }
        for (ClassId classId : section) {
            for (TypeKey typeKey : classId.getInterfacesKey()) {
                if (DexUtils.isJavaFramework(typeKey.getTypeName())) continue;
                interfaceMap.put(typeKey, classId);
            }
        }
    }

    public Iterator<StringId> getStrings() {
        return this.getItems(SectionType.STRING_ID);
    }

    public <T1 extends SectionItem> Iterator<T1> getClonedItems(SectionType<T1> sectionType) {
        Section<T1> section = this.getSectionList().getSection(sectionType);
        if (section != null) {
            return section.clonedIterator();
        }
        return EmptyIterator.of();
    }

    public <T1 extends SectionItem> Iterator<T1> getItems(SectionType<T1> sectionType) {
        Section<T1> section = this.getSectionList().getSection(sectionType);
        if (section != null) {
            return section.iterator();
        }
        return EmptyIterator.of();
    }

    @Override
    public void refreshFull() throws DexException {
        this.onPreRefresh();
        this.sortStrings();
        this.getSectionList().refreshFull();
        this.onRefreshed();
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.interfaceMap.clear();
        this.extendingClassMap.clear();
        this.updateHeaderOffset();
    }

    @Override
    protected void onRefreshed() {
        this.updateChecksumAndSignature();
    }

    private void updateChecksumAndSignature() {
        int i;
        DexHeader dexHeader = this.getHeader();
        SectionList sectionList = this.getSectionList();
        int maximumTrials = 10;
        for (i = 0; i < maximumTrials; ++i) {
            if (!dexHeader.updateChecksum()) {
                if (i != 0) {
                    dexHeader.updateSignature();
                    dexHeader.updateChecksum();
                }
                return;
            }
            sectionList.refresh();
        }
        throw new RuntimeException("Failed to update checksums, trial = " + i);
    }

    private void updateHeaderOffset() {
        DexLayoutBlock previousLayoutBlock = this.getPreviousLayoutBlock();
        int offset = 0;
        if (previousLayoutBlock != null) {
            DexHeader header = previousLayoutBlock.getHeader();
            offset = header.getOffsetReference().get() + header.fileSize.get();
        }
        this.getHeader().getOffsetReference().set(offset);
    }

    private DexLayoutBlock getPreviousLayoutBlock() {
        DexContainerBlock containerBlock = this.getParentInstance(DexContainerBlock.class);
        if (containerBlock != null) {
            return (DexLayoutBlock)containerBlock.get(this.getIndex() - 1);
        }
        return null;
    }

    public void sortSection(SectionType<?>[] order) {
        this.refresh();
        this.getSectionList().sortSection(order);
        this.refresh();
    }

    public int clearEmptySections() {
        return this.getSectionList().clearEmptySections();
    }

    public void clearPoolMap(SectionType<?> sectionType) {
        this.getSectionList().clearPoolMap(sectionType);
    }

    public void clearPoolMap() {
        this.extendingClassMap.clear();
        this.interfaceMap.clear();
        this.getSectionList().clearPoolMap();
    }

    public boolean sortStrings() {
        return this.getSectionList().sortStrings();
    }

    public <T1 extends SectionItem> Iterator<T1> getAll(SectionType<T1> sectionType, Key key) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section.getAll(key);
        }
        return EmptyIterator.of();
    }

    public <T1 extends SectionItem> boolean removeEntries(SectionType<T1> sectionType, Predicate<T1> filter) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section.removeEntries(filter);
        }
        return false;
    }

    public <T1 extends SectionItem> boolean removeWithKeys(SectionType<T1> sectionType, Predicate<? super Key> filter) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section.removeWithKeys(filter);
        }
        return false;
    }

    public <T1 extends SectionItem> boolean removeWithKey(SectionType<T1> sectionType, Key key) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section.remove(key);
        }
        return false;
    }

    public <T1 extends SectionItem> T1 getItem(SectionType<T1> sectionType, Key key) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section.getSectionItem(key);
        }
        return null;
    }

    public <T1 extends SectionItem> Section<T1> getSection(SectionType<T1> sectionType) {
        return this.getSectionList().getSection(sectionType);
    }

    public <T1 extends SectionItem> Section<T1> getOrCreateSection(SectionType<T1> sectionType) {
        return this.getSectionList().getOrCreateSection(sectionType);
    }

    public DexHeader getHeader() {
        return this.getSectionList().getHeader();
    }

    public int getFileSize() {
        return this.getHeader().getFileSize();
    }

    public SectionList getSectionList() {
        return this.sectionList;
    }

    public MapList getMapList() {
        return this.getSectionList().getMapList();
    }

    public boolean isEmpty() {
        Section<ClassId> section = this.getSection(SectionType.CLASS_ID);
        return section == null || section.getCount() == 0;
    }

    public void removeSelf() {
        DexContainerBlock containerBlock = this.getDexContainerBlock();
        if (containerBlock != null) {
            containerBlock.remove(this);
        }
    }

    public DexContainerBlock getDexContainerBlock() {
        return this.getParentInstance(DexContainerBlock.class);
    }

    public boolean merge(MergeOptions options, ClassId classId) {
        return this.getSectionList().merge(options, classId);
    }

    public boolean merge(MergeOptions options, DexLayoutBlock layoutBlock) {
        if (layoutBlock == this) {
            options.onMergeError(this, this.getSectionList(), "Can not merge dex file to self");
            return false;
        }
        return this.getSectionList().merge(options, layoutBlock.getSectionList());
    }

    public ClassId fromSmali(SmaliClass smaliClass) throws IOException {
        return this.getSectionList().fromSmali(smaliClass);
    }

    @Override
    public byte[] getBytes() {
        BytesOutputStream outputStream = new BytesOutputStream(this.getFileSize());
        try {
            this.writeBytes(outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public void readBytes(BlockReader reader, Predicate<SectionType<?>> filter) throws IOException {
        this.getSectionList().readSections(reader, filter);
    }

    public void write(File file) throws IOException {
        OutputStream outputStream = FileUtil.outputStream(file);
        this.writeBytes(outputStream);
        outputStream.close();
    }

    public Object getTag() {
        return this.mTag;
    }

    public void setTag(Object tag) {
        this.mTag = tag;
    }

    public static DexLayoutBlock createDefault() {
        SectionType<?>[] commonTypes;
        DexLayoutBlock dexLayoutBlock = new DexLayoutBlock();
        SectionList sectionList = dexLayoutBlock.getSectionList();
        MapList mapList = sectionList.getMapList();
        mapList.getOrCreate(SectionType.HEADER);
        mapList.getOrCreate(SectionType.MAP_LIST);
        for (SectionType<?> sectionType : commonTypes = SectionType.getR8Order()) {
            sectionList.getOrCreateSection(sectionType);
        }
        sectionList.getMapList().linkHeader(sectionList.getHeader());
        return dexLayoutBlock;
    }
}

