/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.common.BytesOutputStream;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.header.DexHeader;
import com.reandroid.dex.sections.DexLayoutBlock;
import com.reandroid.dex.sections.MergeOptions;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Predicate;

public class DexContainerBlock
extends BlockList<DexLayoutBlock>
implements FullRefresh,
Iterable<DexLayoutBlock> {
    private LayoutBlockChangedListener layoutBlockChangedListener;
    private Object mTag;
    private String mSimpleName;

    public boolean isMultiLayout() {
        return this.size() > 1;
    }

    public boolean isEmpty() {
        for (DexLayoutBlock layoutBlock : this) {
            if (layoutBlock.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clearEmptyLayouts() {
        this.removeIf(DexLayoutBlock::isEmpty);
    }

    public int clearEmptySections() {
        int result = 0;
        for (DexLayoutBlock layoutBlock : this) {
            result += layoutBlock.clearEmptySections();
        }
        return result;
    }

    public void clear() {
        this.clearChildes();
    }

    @Override
    public boolean add(DexLayoutBlock item) {
        boolean added = super.add(item);
        this.notifyAdded(item);
        return added;
    }

    @Override
    public void add(int index, DexLayoutBlock item) {
        super.add(index, item);
        this.notifyAdded(item);
    }

    @Override
    public void clearChildes() {
        super.clearChildes();
        this.notifyLayoutsCleared();
    }

    @Override
    public DexLayoutBlock createNext() {
        DexLayoutBlock layoutBlock = new DexLayoutBlock();
        this.add(layoutBlock);
        this.onCreatedNew(layoutBlock);
        return layoutBlock;
    }

    @Override
    public void ensureSize(int size) {
        while (this.size() < size) {
            this.createNextDefault();
        }
    }

    public DexLayoutBlock createNextDefault() {
        DexLayoutBlock layoutBlock = DexLayoutBlock.createDefault();
        this.add(layoutBlock);
        this.onCreatedNew(layoutBlock);
        return layoutBlock;
    }

    private void onCreatedNew(DexLayoutBlock layoutBlock) {
        if (layoutBlock.getIndex() == 0) {
            return;
        }
        this.fixMinimumVersion();
        layoutBlock.setVersion(((DexLayoutBlock)this.get(0)).getVersion());
    }

    private void fixMinimumVersion() {
        if (this.isMultiLayout()) {
            int minVersion = 41;
            for (DexLayoutBlock layoutBlock : this) {
                if (layoutBlock.getVersion() >= minVersion) continue;
                layoutBlock.setVersion(minVersion);
            }
        }
    }

    @Override
    public void refreshFull() {
        this.clearEmptyLayouts();
        for (DexLayoutBlock layoutBlock : this) {
            layoutBlock.refreshFull();
        }
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.fixMinimumVersion();
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
    }

    @Override
    public void onPreRemove(DexLayoutBlock item) {
        super.onPreRemove(item);
        this.notifyRemoved(item);
    }

    private void notifyAdded(DexLayoutBlock layoutBlock) {
        LayoutBlockChangedListener listener = this.layoutBlockChangedListener;
        if (listener != null) {
            listener.onLayoutAdded(layoutBlock);
        }
    }

    private void notifyRemoved(DexLayoutBlock layoutBlock) {
        LayoutBlockChangedListener listener = this.layoutBlockChangedListener;
        if (listener != null) {
            listener.onLayoutRemoved(layoutBlock);
        }
    }

    private void notifyLayoutsCleared() {
        LayoutBlockChangedListener listener = this.layoutBlockChangedListener;
        if (listener != null) {
            listener.onLayoutsCleared();
        }
    }

    @Override
    protected void onReadBytes(BlockReader reader) throws IOException {
        this.readChildes(reader);
    }

    @Override
    public void readChildes(BlockReader reader) throws IOException {
        this.readBytes(reader, null);
    }

    public void readBytes(BlockReader reader, Predicate<SectionType<?>> filter) throws IOException {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            DexLayoutBlock layoutBlock = (DexLayoutBlock)this.get(i);
            layoutBlock.readBytes(reader, filter);
        }
        while (reader.isAvailable()) {
            this.createNext().readBytes(reader, filter);
        }
    }

    public int getFileSize() {
        int size = 0;
        for (DexLayoutBlock layoutBlock : this) {
            size += layoutBlock.getFileSize();
        }
        return size;
    }

    @Override
    public byte[] getBytes() {
        BytesOutputStream outputStream = new BytesOutputStream(this.getFileSize());
        try {
            this.writeBytes(outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public <T1 extends SectionItem> Iterator<Section<T1>> getSections(SectionType<T1> sectionType) {
        return ComputeIterator.of(this.getSectionLists(), sectionList -> sectionList.getSection(sectionType));
    }

    public Iterator<SectionList> getSectionLists() {
        return ComputeIterator.of(this.iterator(), DexLayoutBlock::getSectionList);
    }

    public int getVersion() {
        DexLayoutBlock first = (DexLayoutBlock)this.getFirst();
        if (first != null) {
            return first.getVersion();
        }
        return 0;
    }

    public void setVersion(int version) {
        for (DexLayoutBlock layoutBlock : this) {
            layoutBlock.setVersion(version);
        }
    }

    public void combineFrom(DexLayoutBlock layoutBlock) {
        this.combineFrom(MergeOptions.DEFAULT, layoutBlock);
    }

    public void combineFrom(MergeOptions options, DexLayoutBlock layoutBlock) {
        if (this.containsExact(layoutBlock) || layoutBlock.isEmpty()) {
            return;
        }
        DexLayoutBlock destination = (DexLayoutBlock)this.getLast();
        if (destination == null || !destination.isEmpty()) {
            destination = this.createNextDefault();
        }
        destination.merge(options, layoutBlock);
        this.fixMinimumVersion();
    }

    public void combineFrom(DexContainerBlock containerBlock) {
        for (DexLayoutBlock layoutBlock : containerBlock) {
            this.combineFrom(layoutBlock);
        }
    }

    public void combineFrom(MergeOptions options, DexContainerBlock containerBlock) {
        for (DexLayoutBlock layoutBlock : containerBlock) {
            this.combineFrom(options, layoutBlock);
        }
    }

    public String getSimpleName() {
        return this.mSimpleName;
    }

    public void setSimpleName(String simpleName) {
        this.mSimpleName = simpleName;
    }

    public Object getTag() {
        return this.mTag;
    }

    public void setTag(Object tag) {
        this.mTag = tag;
    }

    public void setLayoutBlockChangedListener(LayoutBlockChangedListener layoutBlockChangedListener) {
        this.layoutBlockChangedListener = layoutBlockChangedListener;
    }

    public static DexContainerBlock createDefault() {
        DexContainerBlock containerBlock = new DexContainerBlock();
        containerBlock.createNextDefault();
        return containerBlock;
    }

    public static boolean isDexFile(InputStream inputStream) {
        try {
            return DexContainerBlock.isDexFile(DexHeader.readHeader(inputStream));
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isDexFile(File file) {
        if (file == null || !file.isFile()) {
            return false;
        }
        try {
            return DexContainerBlock.isDexFile(DexHeader.readHeader(file));
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private static boolean isDexFile(DexHeader dexHeader) {
        if (dexHeader == null) {
            return false;
        }
        if (!dexHeader.magic.isValid()) {
            return false;
        }
        int version = dexHeader.getVersion();
        return version > 0 && version < 1000;
    }

    public static interface LayoutBlockChangedListener {
        public void onLayoutRemoved(DexLayoutBlock var1);

        public void onLayoutAdded(DexLayoutBlock var1);

        public void onLayoutsCleared();
    }
}

