/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.resource;

import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public abstract class RStyleableItem {
    private final DexField dexField;

    public RStyleableItem(DexField dexField) {
        this.dexField = dexField;
    }

    public String getName() {
        return this.getKey().getName();
    }

    public FieldKey getKey() {
        return this.getDexField().getKey();
    }

    public DexField getDexField() {
        return this.dexField;
    }

    public boolean isValid() {
        DexField dexField = this.getDexField();
        return dexField.isPublic() && dexField.isStatic();
    }

    public void appendJava(SmaliWriter writer) throws IOException {
        DexField dexField = this.getDexField();
        writer.appendModifiers(dexField.getAccessFlags());
        TypeKey typeKey = TypeKey.create(dexField.getKey().getType().getTypeName());
        writer.append(typeKey.getSourceName());
        writer.append(' ');
        writer.append(dexField.getName());
        writer.append(" = ");
        this.appendJavaValue(writer);
        writer.append(';');
    }

    public abstract void appendJavaValue(SmaliWriter var1) throws IOException;

    public void serialize(TableBlock tableBlock, XmlSerializer serializer) throws IOException {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RStyleableItem other = (RStyleableItem)obj;
        return ObjectsUtil.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getName());
    }

    public String toString() {
        return this.getName();
    }
}

