/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.resource;

import com.reandroid.apk.XmlHelper;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.resource.DeclareStyleable;
import com.reandroid.dex.resource.R;
import com.reandroid.dex.resource.RDeclareStyleable;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.UniqueIterator;
import com.reandroid.xml.XMLFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class RSet
implements Iterable<R> {
    private final ArrayCollection<R> rList = new ArrayCollection();

    @Override
    public Iterator<R> iterator() {
        return this.getRList().iterator();
    }

    public void clear() {
        this.getRList().clear();
    }

    public int size() {
        return this.getRList().size();
    }

    public List<DeclareStyleable> listDeclareStyleables(TableBlock tableBlock) {
        ArrayCollection<DeclareStyleable> styleableList = new ArrayCollection<DeclareStyleable>();
        styleableList.addAll(this.getDeclareStyleables(tableBlock));
        styleableList.sort(CompareUtil.getComparableComparator());
        return styleableList;
    }

    public Iterator<DeclareStyleable> getDeclareStyleables(TableBlock tableBlock) {
        return ComputeIterator.of(this.getRDeclareStyleables(), styleable -> styleable.toDeclareStyleable(tableBlock));
    }

    public Iterator<RDeclareStyleable> getRDeclareStyleables() {
        IterableIterator<R, RDeclareStyleable> iterator = new IterableIterator<R, RDeclareStyleable>(this.iterator()){

            @Override
            public Iterator<RDeclareStyleable> iterator(R element) {
                return element.getRDeclareStyleables();
            }
        };
        return new UniqueIterator<RDeclareStyleable>((Iterator<RDeclareStyleable>)iterator);
    }

    private ArrayCollection<R> getRList() {
        return this.rList;
    }

    public void load(DexClassRepository repository) {
        this.rList.addAll(R.findAll(repository));
    }

    public String toXml(TableBlock tableBlock) throws IOException {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XMLFactory.newSerializer(writer);
        this.serialize(tableBlock, serializer);
        serializer.flush();
        writer.close();
        return writer.toString();
    }

    public void serialize(TableBlock tableBlock, XmlSerializer serializer) throws IOException {
        serializer.startDocument("utf8", null);
        XmlHelper.setIndent(serializer, true);
        String tag = "resources";
        serializer.startTag(null, tag);
        List<DeclareStyleable> styleableList = this.listDeclareStyleables(tableBlock);
        for (DeclareStyleable styleable : styleableList) {
            styleable.serialize(serializer);
        }
        XmlHelper.setIndent(serializer, true);
        serializer.endTag(null, tag);
        serializer.endDocument();
    }

    public static List<DeclareStyleable> readStyleables(DexClassRepository repository, TableBlock tableBlock) {
        RSet rSet = new RSet();
        rSet.load(repository);
        return rSet.listDeclareStyleables(tableBlock);
    }
}

