/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.resource;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class REntry
implements IntegerReference {
    private final DexField dexField;

    public REntry(DexField dexField) {
        this.dexField = dexField;
    }

    @Override
    public int get() {
        IntegerReference reference = this.getDexField().getStaticIntegerValue();
        if (reference != null) {
            return reference.get();
        }
        return 0;
    }

    @Override
    public void set(int value) {
        IntegerReference reference = this.getDexField().getStaticIntegerValue();
        if (reference != null) {
            reference.set(value);
        }
    }

    public String getName() {
        return this.getKey().getName();
    }

    public FieldKey getKey() {
        return this.getDexField().getKey();
    }

    public DexField getDexField() {
        return this.dexField;
    }

    public boolean isValid() {
        DexField dexField = this.getDexField();
        return dexField.isPublic() && dexField.isStatic() && PackageBlock.isResourceId(this.get());
    }

    public void appendJava(SmaliWriter writer) throws IOException {
        DexField dexField = this.getDexField();
        writer.appendModifiers(dexField.getAccessFlags());
        TypeKey typeKey = TypeKey.create(dexField.getKey().getType().getTypeName());
        writer.append(typeKey.getSourceName());
        writer.append(' ');
        writer.append(dexField.getName());
        writer.append(" = ");
        writer.appendHex(this.get());
        writer.append(';');
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof REntry)) {
            return false;
        }
        REntry other = (REntry)obj;
        return this.getKey().equals(other.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return this.getName() + " = " + HexUtil.toHex8(this.get());
    }
}

