/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.data.TypeList;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.reference.DataItemIndirectReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.EmptyIterator;
import java.util.Iterator;

public class TypeListReference
extends DataItemIndirectReference<TypeList>
implements Iterable<TypeId> {
    public TypeListReference(SectionItem sectionItem, int offset, int usageType) {
        super(SectionType.TYPE_LIST, sectionItem, offset, usageType);
    }

    @Override
    public Iterator<TypeId> iterator() {
        TypeList typeList = (TypeList)this.getItem();
        if (typeList != null) {
            return typeList.iterator();
        }
        return EmptyIterator.of();
    }

    public Iterator<TypeKey> getTypeKeys() {
        TypeList typeList = (TypeList)this.getItem();
        if (typeList != null) {
            return typeList.getTypeKeys();
        }
        return EmptyIterator.of();
    }

    @Override
    public TypeListKey getKey() {
        return (TypeListKey)super.getKey();
    }

    @Override
    public void setKey(Key key) {
        TypeListKey typeListKey = (TypeListKey)key;
        if (typeListKey != null && typeListKey.isEmpty()) {
            key = null;
        }
        super.setKey(key);
    }

    public void add(TypeKey typeKey) {
        TypeListKey key = this.getKey();
        key = key != null ? key.add(typeKey) : TypeListKey.create(typeKey);
        this.setKey(key);
    }

    public void remove(TypeKey typeKey) {
        TypeListKey key = this.getKey();
        if (key == null) {
            return;
        }
        key = key.remove(typeKey);
        this.setKey(key);
    }

    public void remove(int i) {
        TypeListKey key = this.getKey();
        if (key == null) {
            return;
        }
        key = key.remove(i);
        this.setKey(key);
    }

    public TypeKey getType(int i) {
        TypeId typeId = this.get(i);
        if (typeId != null) {
            return typeId.getKey();
        }
        return null;
    }

    public TypeId get(int i) {
        TypeList typeList = (TypeList)this.getItem();
        if (typeList != null) {
            return (TypeId)typeList.getItem(i);
        }
        return null;
    }

    public TypeId getForRegister(int register) {
        TypeList typeList = (TypeList)this.getItem();
        if (typeList != null) {
            return typeList.getTypeIdForRegister(register);
        }
        return null;
    }

    public int size() {
        TypeList typeList = (TypeList)this.getItem();
        if (typeList != null) {
            return typeList.size();
        }
        return 0;
    }
}

