/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.dex.base.DexException;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.SizeXIns;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.reference.IdSectionReference;
import com.reandroid.dex.sections.SectionType;

public class InsIdSectionReference
extends IdSectionReference<IdItem> {
    public InsIdSectionReference(SizeXIns sizeXIns) {
        super(sizeXIns, UsageMarker.USAGE_INSTRUCTION);
    }

    @Override
    protected SizeXIns getSectionTool() {
        return (SizeXIns)super.getSectionTool();
    }

    @Override
    public int get() {
        return this.getSectionTool().getData();
    }

    @Override
    public void set(int value) {
        this.getSectionTool().setData(value);
    }

    @Override
    protected int onSetKey(int idx) {
        if (idx > 65535 && this.getSectionTool().is(Opcode.CONST_STRING)) {
            idx = 0;
        }
        return idx;
    }

    @Override
    public SectionType<IdItem> getSectionType() {
        return this.getSectionTool().getSectionType();
    }

    @Override
    public IdItem validateReplace(IdItem idItem) {
        idItem = super.validateReplace(idItem);
        return this.validateType(idItem);
    }

    private IdItem validateType(IdItem idItem) {
        Key key = idItem.getKey();
        if (key instanceof TypeKey) {
            TypeKey typeKey = (TypeKey)key;
            if (this.getItem() != null && !typeKey.isTypeObject() && !this.getSectionTool().is(Opcode.CONST_CLASS)) {
                throw new DexException("Unexpected type '" + key + "', " + this.buildTrace(idItem));
            }
        }
        return idItem;
    }

    @Override
    protected String buildTrace(IdItem item) {
        return SizeXIns.buildTrace(this.getSectionTool(), item, this.get());
    }
}

