/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegisterFormat;
import com.reandroid.dex.common.RegisterType;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.id.FieldId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.ins.ConstNumber;
import com.reandroid.dex.ins.ConstNumberLong;
import com.reandroid.dex.ins.ConstString;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsConstStringJumbo;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.RegistersSet;
import com.reandroid.dex.ins.SizeXIns;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexCatch;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexCode;
import com.reandroid.dex.model.DexDeclaration;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.model.DexTry;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class DexInstruction
extends DexCode {
    private final DexMethod dexMethod;
    private Ins mIns;
    private boolean mEdit;

    public DexInstruction(DexMethod dexMethod, Ins ins) {
        this.dexMethod = dexMethod;
        this.mIns = ins;
    }

    public boolean usesRegister(int register) {
        int count = this.getRegistersCount();
        for (int i = 0; i < count; ++i) {
            if (register != this.getRegister(i)) continue;
            return true;
        }
        return false;
    }

    public boolean usesRegister(int register, RegisterType type) {
        RegisterFormat format = this.getOpcode().getRegisterFormat();
        int count = this.getRegistersCount();
        for (int i = 0; i < count; ++i) {
            if (register != this.getRegister(i) || !type.is(format.get(i))) continue;
            return true;
        }
        return false;
    }

    public int getAddress() {
        return this.getIns().getAddress();
    }

    public int getCodeUnits() {
        return this.getIns().getCodeUnits();
    }

    public List<Register> getLocalFreeRegisters() {
        return this.getDexMethod().getLocalFreeRegisters(this.getIndex());
    }

    public String getString() {
        IdItem idItem = this.getIdSectionEntry();
        if (idItem instanceof StringId) {
            return ((StringId)idItem).getString();
        }
        return null;
    }

    public void setString(String text) {
        this.setKey(StringKey.create(text));
    }

    public DexInstruction setStringWithJumbo(String text) {
        SizeXIns sizeXIns = (SizeXIns)this.edit();
        StringId stringId = sizeXIns.getOrCreateSectionItem(SectionType.STRING_ID, StringKey.create(text));
        if ((stringId.getIdx() & 0xFFFF0000) == 0 || !sizeXIns.is(Opcode.CONST_STRING)) {
            sizeXIns.setSectionId(stringId);
            return this;
        }
        int register = ((RegistersSet)((Object)sizeXIns)).getRegister();
        InsConstStringJumbo jumbo = sizeXIns.replace(Opcode.CONST_STRING_JUMBO);
        jumbo.setRegister(register);
        jumbo.setSectionId(stringId);
        return DexInstruction.create(this.getDexMethod(), jumbo);
    }

    public FieldKey getFieldKey() {
        IdItem idItem = this.getIdSectionEntry();
        if (idItem instanceof FieldId) {
            return ((FieldId)idItem).getKey();
        }
        return null;
    }

    public MethodKey getMethodKey() {
        IdItem idItem = this.getIdSectionEntry();
        if (idItem instanceof MethodId) {
            return ((MethodId)idItem).getKey();
        }
        return null;
    }

    public Key getKey() {
        IdItem entry = this.getIdSectionEntry();
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public void setKey(Key key) {
        Ins ins = this.getIns();
        if (ins instanceof SizeXIns) {
            ((SizeXIns)this.edit()).setKey(key);
        }
    }

    public IdItem getIdSectionEntry() {
        Ins ins = this.getIns();
        if (ins instanceof SizeXIns) {
            return ((SizeXIns)ins).getSectionId();
        }
        return null;
    }

    public int getRegister(int i) {
        if (i < 0) {
            return -1;
        }
        Ins ins = this.getIns();
        if (ins instanceof RegistersSet) {
            RegistersSet registersSet = (RegistersSet)((Object)ins);
            if (i >= registersSet.getRegistersCount()) {
                return -1;
            }
            return registersSet.getRegister(i);
        }
        return -1;
    }

    public int getRegister() {
        return this.getRegister(0);
    }

    public int getRegistersCount() {
        Ins ins = this.getIns();
        if (ins instanceof RegistersSet) {
            return ((RegistersSet)((Object)ins)).getRegistersCount();
        }
        return 0;
    }

    public void setRegister(int register) {
        this.setRegister(0, register);
    }

    public void setRegister(int i, int register) {
        Ins ins = this.getIns();
        if (ins instanceof RegistersSet) {
            this.ensureRegistersCount(i + 1);
            ((RegistersSet)((Object)ins)).setRegister(i, register);
        }
    }

    public boolean removeRegisterAt(int index) {
        Ins ins = this.edit();
        if (ins instanceof RegistersSet) {
            return ((RegistersSet)((Object)ins)).removeRegisterAt(index);
        }
        return false;
    }

    private void ensureRegistersCount(int count) {
        if (count > this.getRegistersCount() && this.getOpcode().getRegisterFormat().isOut()) {
            this.setRegistersCount(count);
        }
    }

    public void setRegistersCount(int count) {
        if (this.getIns() instanceof RegistersSet) {
            ((RegistersSet)((Object)this.edit())).setRegistersCount(count);
        }
    }

    public boolean is(Opcode<?> opcode) {
        return opcode == this.getOpcode();
    }

    public boolean isConstString() {
        return this.getIns() instanceof ConstString;
    }

    public boolean isNumber() {
        return this.getIns() instanceof ConstNumber;
    }

    public boolean isNumberLong() {
        return this.getIns() instanceof ConstNumberLong;
    }

    public int getTargetAddress() {
        Ins ins = this.getIns();
        if (ins instanceof Label) {
            return ((Label)((Object)ins)).getTargetAddress();
        }
        return -1;
    }

    public void setTargetAddress(int address) {
        if (this.getIns() instanceof Label) {
            ((Label)((Object)this.edit())).setTargetAddress(address);
        }
    }

    public IntegerReference getAsIntegerReference() {
        Ins ins = this.getIns();
        if (ins instanceof ConstNumber) {
            return (ConstNumber)((Object)ins);
        }
        return null;
    }

    public Integer getAsInteger() {
        Ins ins = this.getIns();
        if (ins instanceof ConstNumber) {
            return ((ConstNumber)((Object)ins)).get();
        }
        return null;
    }

    public Long getAsLong() {
        Ins ins = this.getIns();
        if (ins instanceof ConstNumberLong) {
            return ((ConstNumberLong)((Object)ins)).getLong();
        }
        return null;
    }

    public void setAsInteger(int value) {
        Ins ins = this.edit();
        if (ins instanceof ConstNumber) {
            ((ConstNumber)((Object)ins)).set(value);
        }
    }

    public void setAsLong(long value) {
        Ins ins = this.edit();
        if (ins instanceof ConstNumberLong) {
            ((ConstNumberLong)((Object)ins)).set(value);
        }
    }

    public boolean trapsCatchAll() {
        return this.traps(null);
    }

    public boolean traps(TypeKey typeKey) {
        return this.getCatches(typeKey).hasNext();
    }

    public Iterator<DexCatch> getCatches(TypeKey typeKey) {
        return FilterIterator.of(this.getCatches(), dexCatch -> dexCatch.traps(typeKey));
    }

    public Iterator<DexCatch> getCatches() {
        final int address = this.getAddress();
        return new IterableIterator<DexTry, DexCatch>(this.getTries()){

            @Override
            public Iterator<DexCatch> iterator(DexTry element) {
                return element.getCatches(address);
            }
        };
    }

    public Iterator<DexTry> getTries() {
        return this.getDexMethod().getDexTry(this.getAddress());
    }

    public DexInstruction replace(String smaliString) throws IOException {
        return this.replace(SmaliReader.of(smaliString));
    }

    public DexInstruction replace(SmaliReader reader) throws IOException {
        SmaliInstruction smaliInstruction = new SmaliInstruction();
        smaliInstruction.parse(reader);
        Object ins = this.edit().replace(smaliInstruction.getOpcode());
        ((Ins)ins).fromSmali(smaliInstruction);
        return DexInstruction.create(this.getDexMethod(), ins);
    }

    public DexInstruction createNext(String smaliString) throws IOException {
        return this.createNext(SmaliReader.of(smaliString));
    }

    public DexInstruction createNext(SmaliReader reader) throws IOException {
        SmaliInstruction smaliInstruction = new SmaliInstruction();
        smaliInstruction.parse(reader);
        Object ins = this.edit().createNext(smaliInstruction.getOpcode());
        ((Ins)ins).fromSmali(smaliInstruction);
        return DexInstruction.create(this.getDexMethod(), ins);
    }

    public DexInstruction replace(Opcode<?> opcode) {
        return DexInstruction.create(this.getDexMethod(), this.edit().replace(opcode));
    }

    public DexInstruction createNext(Opcode<?> opcode) {
        return DexInstruction.create(this.getDexMethod(), this.edit().createNext(opcode));
    }

    @Override
    public void removeSelf() {
        Ins ins = this.edit();
        InstructionList instructionList = ins.getInstructionList();
        if (instructionList != null) {
            instructionList.remove(ins);
        }
    }

    public Opcode<?> getOpcode() {
        return this.getIns().getOpcode();
    }

    public Ins getIns() {
        int index;
        Ins ins = this.mIns;
        if (this.mEdit) {
            return ins;
        }
        DexMethod dexMethod = this.getDexMethod();
        int editIndex = dexMethod.getEditIndex();
        if (editIndex < (index = ins.getIndex())) {
            this.mIns = ins = dexMethod.getDefinition().getInstruction(index);
            this.mEdit = true;
        }
        return ins;
    }

    public Ins edit() {
        Ins ins = this.getIns();
        if (this.mEdit) {
            return ins;
        }
        ins = this.mIns.edit();
        if (ins != this.mIns) {
            this.getDexMethod().setEditIndex(ins.getIndex());
            this.mIns = ins;
            this.mEdit = true;
        }
        return ins;
    }

    @Override
    public boolean uses(Key key) {
        Key insKey = this.getKey();
        if (insKey != null) {
            return insKey.uses(key);
        }
        return false;
    }

    @Override
    public DexMethod getDexMethod() {
        return this.dexMethod;
    }

    public DexDeclaration findDeclaration() {
        DexClassRepository dexClassRepository;
        Key key = this.getKey();
        if (key != null && (dexClassRepository = this.getClassRepository()) != null) {
            return dexClassRepository.getDexDeclaration(key);
        }
        return null;
    }

    public DexInstruction getNext() {
        return this.getDexMethod().getInstruction(this.getIndex() + 1);
    }

    public DexInstruction getPrevious() {
        return this.getDexMethod().getInstruction(this.getIndex() - 1);
    }

    public DexInstruction getPreviousReader(int register) {
        return this.getPreviousReader(register, CollectionUtil.getAcceptAll());
    }

    public DexInstruction getPreviousReader(int register, Opcode<?> opcode) {
        return this.getPreviousReader(register, (DexInstruction instruction) -> instruction.is(opcode));
    }

    public DexInstruction getPreviousReader(int register, Predicate<DexInstruction> predicate) {
        for (DexInstruction previous = this.getPrevious(); previous != null; previous = previous.getPrevious()) {
            Opcode<?> opcode = previous.getOpcode();
            if (opcode.isMover() && previous.getRegister(0) == register) {
                register = previous.getRegister(1);
                continue;
            }
            RegisterFormat format = opcode.getRegisterFormat();
            int size = previous.getRegistersCount();
            for (int i = 0; i < size; ++i) {
                if (register != previous.getRegister(i) || !RegisterType.READ.is(format.get(i))) continue;
                if (predicate.test(previous)) {
                    return previous;
                }
                return null;
            }
        }
        return null;
    }

    public DexInstruction getPreviousSetter(int register) {
        return this.getPreviousSetter(register, CollectionUtil.getAcceptAll());
    }

    public DexInstruction getPreviousSetter(int register, Opcode<?> opcode) {
        return this.getPreviousSetter(register, (DexInstruction instruction) -> instruction.is(opcode));
    }

    public DexInstruction getPreviousSetter(int register, Predicate<DexInstruction> predicate) {
        for (DexInstruction previous = this.getPrevious(); previous != null; previous = previous.getPrevious()) {
            Opcode<?> opcode = previous.getOpcode();
            if (opcode.isMover() && previous.getRegister(1) == register) {
                register = previous.getRegister(0);
                continue;
            }
            RegisterFormat format = opcode.getRegisterFormat();
            int size = previous.getRegistersCount();
            for (int i = 0; i < size; ++i) {
                if (register != previous.getRegister(i) || !RegisterType.WRITE.is(format.get(i))) continue;
                if (predicate.test(previous)) {
                    return previous;
                }
                return null;
            }
        }
        return null;
    }

    public int getIndex() {
        return this.getIns().getIndex();
    }

    public void moveBackward() {
        int index = this.getIndex();
        if (index != 0) {
            this.edit().moveTo(index - 1);
        }
    }

    public void moveForward() {
        int index = this.getIndex() + 1;
        if (index < this.getDexMethod().getInstructionsCount()) {
            this.edit().moveTo(index);
        }
    }

    public void moveTo(int index) {
        this.edit().moveTo(index);
    }

    public void merge(DexInstruction other) {
        this.getIns().merge(other.getIns());
    }

    @Override
    public DexClassRepository getClassRepository() {
        return this.getDexMethod().getClassRepository();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getIns().append(writer);
    }

    @Override
    public String toString() {
        return this.getIns().toString();
    }

    public static Iterator<DexInstruction> create(DexMethod dexMethod, Iterator<Ins> iterator) {
        if (dexMethod == null) {
            return EmptyIterator.of();
        }
        return ComputeIterator.of(iterator, ins -> DexInstruction.create(dexMethod, ins));
    }

    public static DexInstruction create(DexMethod dexMethod, Ins ins) {
        if (dexMethod == null || ins == null) {
            return null;
        }
        return new DexInstruction(dexMethod, ins);
    }
}

