/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexAnnotation;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.smali.SmaliWriter;
import java.io.IOException;

public class DexAnnotationElement
extends Dex {
    private final DexAnnotation dexAnnotation;
    private String name;
    private AnnotationElementKey mRemoved;

    public DexAnnotationElement(DexAnnotation dexAnnotation, String name) {
        this.dexAnnotation = dexAnnotation;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.setKey(this.getKey().changeName(name));
    }

    public AnnotationElementKey getKey() {
        AnnotationElementKey key = this.mRemoved;
        if (key == null) {
            key = this.getDexAnnotation().getKey().get(this.getName());
        }
        return key;
    }

    public void setKey(Key key) {
        AnnotationElementKey elementKey = (AnnotationElementKey)key;
        DexAnnotation annotation = this.getDexAnnotation();
        AnnotationItemKey itemKey = annotation.getKey().remove(this.getName()).add(elementKey);
        annotation.setKey(itemKey);
        this.name = elementKey.getName();
    }

    public Key getValue() {
        return this.getKey().getValue();
    }

    public void setValue(Key value) {
        this.setKey(this.getKey().changeValue(value));
    }

    @Override
    public void removeSelf() {
        if (!this.isRemoved()) {
            this.applyRemoveSelf();
        }
    }

    public boolean isRemoved() {
        this.checkRemoved();
        return this.name == null;
    }

    private void checkRemoved() {
        DexAnnotation annotation = this.getDexAnnotation();
        if (annotation.isRemoved()) {
            this.applyRemoveSelf();
            return;
        }
        AnnotationElementKey key = this.mRemoved;
        if (key != null && !annotation.isRemoved()) {
            String name = key.getName();
            if (annotation.contains(key.getName())) {
                this.name = name;
                this.mRemoved = null;
            }
        }
    }

    private void applyRemoveSelf() {
        AnnotationElementKey key = this.mRemoved;
        if (key != null) {
            this.name = null;
            return;
        }
        key = this.getKey();
        this.name = null;
        if (key != null) {
            this.mRemoved = key;
            this.getDexAnnotation().remove(key.getName());
        }
    }

    public TypeKey getType() {
        return this.getDexAnnotation().getType();
    }

    public DexAnnotation getDexAnnotation() {
        return this.dexAnnotation;
    }

    @Override
    public boolean uses(Key key) {
        return this.getKey().uses(key);
    }

    @Override
    public DexClassRepository getClassRepository() {
        return this.getDexAnnotation().getClassRepository();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        if (!this.isRemoved()) {
            this.getKey().append(writer);
        }
    }

    @Override
    public String toString() {
        AnnotationElementKey key = this.getKey();
        if (this.isRemoved()) {
            return "#REMOVED " + key;
        }
        return String.valueOf(key);
    }

    public static DexAnnotationElement create(DexAnnotation dexAnnotation, String name) {
        if (dexAnnotation != null && name != null) {
            return new DexAnnotationElement(dexAnnotation, name);
        }
        return null;
    }

    public static DexAnnotationElement create(DexAnnotation dexAnnotation, AnnotationElementKey elementKey) {
        if (dexAnnotation != null && elementKey != null) {
            return DexAnnotationElement.create(dexAnnotation, elementKey.getName());
        }
        return null;
    }
}

