/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyList;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import java.io.IOException;

public class TypeListKey
extends KeyList<TypeKey> {
    private static final TypeListKey EMPTY = new TypeListKey(EMPTY_ARRAY);

    private TypeListKey(Key[] keys) {
        super(keys);
    }

    public TypeListKey remove(int index) {
        return (TypeListKey)super.remove(index);
    }

    TypeListKey newInstance(Key[] elements) {
        return TypeListKey.create(elements);
    }

    public TypeListKey add(TypeKey typeKey) {
        return (TypeListKey)super.add(typeKey);
    }

    public TypeListKey remove(TypeKey itemKey) {
        return (TypeListKey)super.remove(itemKey);
    }

    public TypeListKey set(int i, TypeKey item) {
        return (TypeListKey)super.set(i, item);
    }

    public boolean contains(TypeKey typeKey) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!ObjectsUtil.equals(typeKey, this.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypeListKey replaceKey(Key search, Key replace) {
        return (TypeListKey)super.replaceKey(search, replace);
    }

    public void appendInterfaces(SmaliWriter writer) throws IOException {
        int size = this.size();
        if (size == 0) {
            return;
        }
        writer.newLine();
        writer.newLine();
        writer.appendComment("interfaces");
        SmaliDirective directive = SmaliDirective.IMPLEMENTS;
        for (int i = 0; i < size; ++i) {
            writer.newLine();
            directive.append(writer);
            ((TypeKey)this.get(i)).append(writer);
        }
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof TypeListKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        return this.compareElements((TypeListKey)obj);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TypeListKey) {
            return this.equalsElements((TypeListKey)obj);
        }
        return false;
    }

    @Override
    public String toString() {
        return '(' + StringsUtil.join(this.iterator(), null) + ')';
    }

    public static TypeListKey empty() {
        return EMPTY;
    }

    public static TypeListKey create(Key ... keys) {
        if ((keys = TypeListKey.removeNulls(keys)) == EMPTY_ARRAY) {
            return TypeListKey.empty();
        }
        return new TypeListKey(keys);
    }

    public static TypeListKey readParameters(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, '(');
        reader.skipWhitespacesOrComment();
        ArrayCollection<TypeKey> keys = null;
        while (!reader.finished() && reader.get() != 41) {
            if (keys == null) {
                keys = new ArrayCollection<TypeKey>();
            }
            keys.add(TypeKey.read(reader));
            reader.skipWhitespacesOrComment();
        }
        SmaliParseException.expect(reader, ')');
        if (keys == null) {
            return TypeListKey.empty();
        }
        return TypeListKey.create(keys.toArrayFill(new TypeKey[keys.size()]));
    }

    public static TypeListKey parseParameters(String parameters) {
        return TypeListKey.parseParameters(parameters, 0, parameters.length());
    }

    public static TypeListKey parseParameters(String text, int start, int end) {
        if (end == start) {
            return TypeListKey.empty();
        }
        if (start > end) {
            return null;
        }
        ArrayCollection<TypeKey> results = new ArrayCollection<TypeKey>();
        while (start < end) {
            TypeKey typeKey = TypeKey.parseBinaryType(text, start, end);
            if (typeKey == null) {
                return null;
            }
            results.add(typeKey);
            start += typeKey.getTypeName().length();
        }
        return TypeListKey.create(results.toArrayFill(new TypeKey[results.size()]));
    }
}

