/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class StringKey
implements Key {
    private final String text;
    public static final StringKey EMPTY = new StringKey(StringsUtil.EMPTY);

    public StringKey(String text) {
        this.text = text;
    }

    public String getString() {
        return this.text;
    }

    public String getEncodedString() {
        return DexUtils.encodeString(this.getString());
    }

    public String getQuoted() {
        return DexUtils.quoteString(this.getString());
    }

    public String getAsSimpleName() {
        return StringKey.encodeSimpleName(this.getString());
    }

    @Override
    public TypeKey getDeclaring() {
        return null;
    }

    public Iterator<Key> mentionedKeys() {
        return CombiningIterator.singleOne(this.getDeclaring(), SingleIterator.of(this));
    }

    @Override
    public Key replaceKey(Key search, Key replace) {
        if (search.equals(this)) {
            return replace;
        }
        return this;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.append(writer, false);
    }

    public void append(SmaliWriter writer, boolean enableComment) throws IOException {
        writer.append('\"');
        boolean unicodeDetected = DexUtils.encodeString(writer, this.getString());
        writer.append('\"');
        if (enableComment && unicodeDetected && writer.isCommentUnicodeStrings()) {
            DexUtils.appendCommentString(250, writer.getCommentAppender(), this.getString());
        }
    }

    public void appendSimpleName(SmaliWriter writer) throws IOException {
        writer.append(this.getAsSimpleName());
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof StringKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        StringKey key = (StringKey)obj;
        return CompareUtil.compare(this.getString(), key.getString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringKey)) {
            return false;
        }
        StringKey stringKey = (StringKey)obj;
        return ObjectsUtil.equals(this.getString(), stringKey.getString());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public String toString() {
        return this.getQuoted();
    }

    public static StringKey create(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return EMPTY;
        }
        return new StringKey(text);
    }

    public static StringKey parseQuotedString(String quotedString) {
        String str;
        if (quotedString == null || quotedString.length() < 2) {
            return null;
        }
        SmaliReader reader = SmaliReader.of(quotedString);
        if (reader.get() != 34) {
            return null;
        }
        try {
            reader.skip(1);
            str = reader.readEscapedString('\"');
            if (reader.available() != 1 || reader.get() != 34) {
                return null;
            }
        }
        catch (IOException ignored) {
            return null;
        }
        return StringKey.create(str);
    }

    public static StringKey read(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        SmaliParseException.expect(reader, '\"');
        String str = reader.readEscapedString('\"');
        SmaliParseException.expect(reader, '\"');
        return StringKey.create(str);
    }

    public static String encodeSimpleName(String name) {
        StringBuilder builder = null;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            String encoded = StringKey.encodeSimpleName(c);
            if (encoded != null) {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(name, 0, i);
                }
                builder.append(encoded);
                continue;
            }
            if (builder == null) continue;
            builder.append(c);
        }
        if (builder == null) {
            return name;
        }
        return builder.toString();
    }

    private static String encodeSimpleName(char c) {
        String encoded = c == ' ' ? HexUtil.toHex("\\u", c, 4) : (c == '\n' ? "\\n" : (c == '\r' ? "\\r" : (c == '\t' ? "\\t" : (c == '\b' ? "\\b" : (c == '\f' ? "\\f" : null)))));
        return encoded;
    }

    public static String decodeEscapedString(String encoded) {
        return StringKey.decodeEscapedString(encoded, 0);
    }

    public static String decodeEscapedString(String encoded, int start) {
        StringBuilder builder = null;
        int length = encoded.length();
        boolean escaped = false;
        for (int i = start; i < length; ++i) {
            char c = encoded.charAt(i);
            if (escaped) {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(encoded, start, i - 1);
                }
                if (c == 'u') {
                    Character hex = StringKey.decodeNextHex(encoded, i + 1);
                    if (hex != null) {
                        builder.append(hex.charValue());
                        i += 4;
                    } else {
                        builder.append(c);
                    }
                } else {
                    builder.append(StringKey.getEscaped(c));
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (builder == null) continue;
            builder.append(c);
        }
        if (builder == null) {
            return encoded;
        }
        return builder.toString();
    }

    private static char getEscaped(char c) {
        if (c == 'n') {
            return '\n';
        }
        if (c == 'b') {
            return '\b';
        }
        if (c == 'f') {
            return '\f';
        }
        if (c == 'r') {
            return '\r';
        }
        if (c == 't') {
            return '\t';
        }
        return c;
    }

    private static Character decodeNextHex(String text, int start) {
        int end = start + 4;
        int length = text.length();
        if (end > length) {
            return null;
        }
        int value = 0;
        for (int i = start; i < end; ++i) {
            int v = HexUtil.decodeHexChar(text.charAt(i));
            if (v == -1) {
                return null;
            }
            value <<= 4;
            value |= v;
        }
        return Character.valueOf((char)value);
    }

    public static StringKey readSimpleName(SmaliReader reader, char stopChar) throws IOException {
        int position = reader.position();
        String name = reader.readEscapedString(stopChar);
        SmaliParseException.expect(reader, stopChar);
        reader.skip(-1);
        String error = StringKey.validateSimpleName(name);
        if (error != null) {
            reader.position(position);
            throw new SmaliParseException(error, reader);
        }
        return StringKey.create(name);
    }

    public static StringKey readSimpleName(SmaliReader reader) throws IOException {
        return StringKey.create(reader.readSimpleNameIgnoreWhitespaces());
    }

    private static String validateSimpleName(String name) {
        int length = name.length();
        if (length == 0) {
            return "Invalid name";
        }
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (!StringKey.isInvalidSimpleName(c)) continue;
            return "Invalid name character '" + c + "'";
        }
        return null;
    }

    private static boolean isInvalidSimpleName(char c) {
        return c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}' || c == ';' || c == '/' || c == '\\' || c == ':' || c == '.' || c == '*' || c == '%' || c == '|' || c == '^';
    }
}

