/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.utils.HexUtil;

class PrimitiveKeyHelper {
    PrimitiveKeyHelper() {
    }

    public static PrimitiveKey parse(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        char first = text.charAt(0);
        if (PrimitiveKeyHelper.isNumbersPrefix(first)) {
            return PrimitiveKeyHelper.parseNumbers(text);
        }
        if (first == '\'') {
            return PrimitiveKeyHelper.parseChar(text);
        }
        if (first == 't' || first == 'f') {
            return PrimitiveKeyHelper.parseBoolean(text);
        }
        return null;
    }

    public static PrimitiveKey readSafe(SmaliReader reader) {
        if (reader.finished()) {
            return null;
        }
        int position = reader.position();
        char first = reader.getASCII(position);
        if (PrimitiveKeyHelper.isNumbersPrefix(first)) {
            return PrimitiveKeyHelper.readNumbers(reader);
        }
        if (first == '\'') {
            return PrimitiveKeyHelper.readChar(reader);
        }
        if (first == 't' || first == 'f') {
            return PrimitiveKeyHelper.readBoolean(reader);
        }
        reader.position(position);
        return null;
    }

    private static PrimitiveKey readChar(SmaliReader reader) {
        int position = reader.position();
        if (reader.read() != 39) {
            reader.position(position);
            return null;
        }
        int ch = reader.readASCII();
        if (ch == 92) {
            ch = reader.readASCII();
            if (ch == 117) {
                try {
                    int i = HexUtil.parseHex(reader.readString(4));
                    ch = (char)i;
                }
                catch (NumberFormatException ex) {
                    reader.position(position);
                    return null;
                }
            } else if (ch == 98) {
                ch = 8;
            } else if (ch == 102) {
                ch = 12;
            } else if (ch == 110) {
                ch = 10;
            } else if (ch == 114) {
                ch = 13;
            } else if (ch == 116) {
                ch = 9;
            } else {
                reader.position(position);
                return null;
            }
        }
        if (reader.read() != 39) {
            reader.position(position);
            return null;
        }
        return PrimitiveKey.of((char)ch);
    }

    private static PrimitiveKey parseChar(String text) {
        if (text.length() < 3) {
            return null;
        }
        if (text.charAt(0) != '\'') {
            return null;
        }
        int last = text.length() - 1;
        if (text.charAt(last) != '\'') {
            return null;
        }
        text = text.substring(1, last);
        int c = text.charAt(0);
        if (text.length() == 1) {
            return PrimitiveKey.of((char)c);
        }
        if (c != 92) {
            return null;
        }
        c = text.charAt(1);
        if (c == 117) {
            if (text.length() == 6) {
                try {
                    return PrimitiveKey.of((char)HexUtil.parseHex(text.substring(2)));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (text.length() == 2) {
            if (c == 98) {
                c = 8;
            } else if (c == 102) {
                c = 12;
            } else if (c == 110) {
                c = 10;
            } else if (c == 114) {
                c = 13;
            } else if (c == 116) {
                c = 9;
            } else {
                return null;
            }
            return PrimitiveKey.of((char)c);
        }
        return null;
    }

    private static PrimitiveKey readBoolean(SmaliReader reader) {
        int position = reader.position();
        char first = reader.readASCII();
        if (first == 't') {
            if (reader.read() == 114 && reader.read() == 117 && reader.read() == 101) {
                return PrimitiveKey.of(true);
            }
        } else if (first == 'f' && reader.read() == 97 && reader.read() == 108 && reader.read() == 115 && reader.read() == 101) {
            return PrimitiveKey.of(false);
        }
        reader.position(position);
        return null;
    }

    private static PrimitiveKey parseBoolean(String text) {
        if (text.equals("true")) {
            return PrimitiveKey.of(true);
        }
        if (text.equals("false")) {
            return PrimitiveKey.of(false);
        }
        return null;
    }

    private static PrimitiveKey readNumbers(SmaliReader reader) {
        int position = reader.position();
        char first = reader.readASCII();
        if (first == '-' || first == '+') {
            first = reader.readASCII();
        }
        char x = '\u0000';
        if (!reader.finished()) {
            x = reader.readASCII();
        }
        reader.position(position);
        String number = reader.readStringForNumber();
        if (first == '0' && x == 'x') {
            try {
                return PrimitiveKeyHelper.readHex(number);
            }
            catch (NumberFormatException ignored) {
                reader.position(position);
                return null;
            }
        }
        if (number.charAt(0) == '+') {
            number = number.substring(1);
        }
        if (PrimitiveKeyHelper.isFloatOrDouble(number)) {
            try {
                return PrimitiveKeyHelper.parseFloatOrDouble(number);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            try {
                return PrimitiveKeyHelper.parsePlainNumber(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        reader.position(position);
        return null;
    }

    private static PrimitiveKey parseNumbers(String text) {
        int position = 0;
        char first = text.charAt(position);
        int length = text.length();
        if (length > 1 && (first == '-' || first == '+')) {
            first = text.charAt(1);
            ++position;
        }
        char x = '\u0000';
        if (length > position + 1) {
            x = text.charAt(position + 1);
        }
        String number = text;
        if (first == '0' && x == 'x') {
            try {
                return PrimitiveKeyHelper.readHex(text);
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        if (number.charAt(0) == '+') {
            number = number.substring(1);
        }
        if (PrimitiveKeyHelper.isFloatOrDouble(number)) {
            try {
                return PrimitiveKeyHelper.parseFloatOrDouble(number);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            try {
                return PrimitiveKeyHelper.parsePlainNumber(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static PrimitiveKey parsePlainNumber(String number) {
        char suffix = number.charAt(number.length() - 1);
        if (suffix == 'L' || suffix == 'l') {
            number = number.substring(0, number.length() - 1);
            return PrimitiveKey.of(Long.parseLong(number));
        }
        return PrimitiveKey.of(Integer.parseInt(number));
    }

    private static PrimitiveKey parseFloatOrDouble(String number) {
        int lastIndex = number.length() - 1;
        if (number.charAt(lastIndex) == 'f') {
            number = number.substring(0, lastIndex);
            return PrimitiveKey.of(Float.parseFloat(number));
        }
        return PrimitiveKey.of(Double.parseDouble(number));
    }

    private static boolean isFloatOrDouble(String number) {
        if (number.indexOf(46) >= 0) {
            return true;
        }
        return number.contains("NaN") || number.contains("Infinity");
    }

    private static PrimitiveKey readHex(String hex) {
        char suffix = hex.charAt(hex.length() - 1);
        if (suffix == 'L') {
            return PrimitiveKey.of(HexUtil.parseHexLong(hex));
        }
        if (suffix == 'S' || suffix == 's') {
            return PrimitiveKey.of(HexUtil.parseHexShort(hex));
        }
        if (suffix == 't') {
            return PrimitiveKey.of(HexUtil.parseHexByte(hex));
        }
        return PrimitiveKey.of(HexUtil.parseHexInteger(hex));
    }

    private static boolean isNumbersPrefix(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '-' || c == '+' || c == 'N' || c == 'I';
    }
}

