/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.ArrayKey;
import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.DalvikSignatureBuilder;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.ParameterisedProtoKey;
import com.reandroid.dex.key.ParameterisedTypeKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;

public class DalvikSignatureKey
extends ArrayKey<ParameterisedTypeKey> {
    private DalvikSignatureKey(Key[] elements) {
        super(elements);
    }

    public ParameterisedTypeKey getProtoParameter(int parameterIndex) {
        ParameterisedProtoKey protoKey = this.getMethodProto();
        if (protoKey != null) {
            return (ParameterisedTypeKey)protoKey.get(parameterIndex);
        }
        return null;
    }

    public ParameterisedProtoKey getMethodProto() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ParameterisedTypeKey typeKey = (ParameterisedTypeKey)this.get(i);
            ParameterisedProtoKey protoKey = typeKey.getProtoKey();
            if (!protoKey.isMethod()) continue;
            return protoKey;
        }
        return null;
    }

    public Iterator<TypeKey> getTypes() {
        return new IterableIterator<ParameterisedTypeKey, TypeKey>(this.iterator()){

            @Override
            public Iterator<TypeKey> iterator(ParameterisedTypeKey element) {
                return element.getTypes();
            }
        };
    }

    public ArrayValueKey toStringValues() {
        DalvikSignatureBuilder builder = new DalvikSignatureBuilder();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((ParameterisedTypeKey)this.get(i)).buildSignature(builder);
        }
        builder.flush();
        return builder.build();
    }

    @Override
    public DalvikSignatureKey replaceKey(Key search, Key replace) {
        return (DalvikSignatureKey)super.replaceKey(search, replace);
    }

    @Override
    protected DalvikSignatureKey newInstance(Key[] elements) {
        return DalvikSignatureKey.createKey(elements);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((ParameterisedTypeKey)this.get(i)).appendString(builder, false);
        }
        return builder.toString();
    }

    public static DalvikSignatureKey of(ParameterisedTypeKey ... elements) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        return DalvikSignatureKey.createKey(elements);
    }

    private static DalvikSignatureKey createKey(Key[] elements) {
        return new DalvikSignatureKey(elements);
    }

    public static DalvikSignatureKey parseAnnotationValue(ArrayValueKey stringsKey) {
        if (stringsKey != null) {
            return DalvikSignatureKey.parse(StringsUtil.join(stringsKey.stringValuesIterator(), (Object)""));
        }
        return null;
    }

    public static DalvikSignatureKey parse(String text) {
        try {
            return DalvikSignatureKey.read(SmaliReader.of(text));
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static DalvikSignatureKey read(SmaliReader reader) throws IOException {
        reader = DalvikSignatureKey.ensurePlainString(reader);
        ArrayCollection<ParameterisedTypeKey> results = null;
        while (!reader.finished() && !reader.skipWhitespaces()) {
            ParameterisedTypeKey typeKey = ParameterisedTypeKey.read(reader);
            if (results == null) {
                results = new ArrayCollection<ParameterisedTypeKey>();
            }
            results.add(typeKey);
        }
        if (results == null) {
            if (reader.finished()) {
                throw new IOException("EOF: Invalid signature");
            }
            reader.position(reader.position() - 1);
            throw new SmaliParseException("Whitespace detected", reader);
        }
        return DalvikSignatureKey.createKey(results.toArrayFill(new Key[results.size()]));
    }

    private static SmaliReader ensurePlainString(SmaliReader reader) throws IOException {
        if (reader.finished()) {
            return reader;
        }
        int position = reader.position();
        reader.skipWhitespacesOrComment();
        if (reader.finished() || reader.get() != 123) {
            reader.position(position);
            return reader;
        }
        ArrayValueKey arrayKey = ArrayValueKey.read(reader);
        String plain = StringsUtil.join(arrayKey.stringValuesIterator(), (Object)"");
        return SmaliReader.of(plain);
    }
}

