/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.Ins22c;
import com.reandroid.dex.ins.Ins31t;
import com.reandroid.dex.ins.InsArrayData;
import com.reandroid.dex.ins.Opcode;

public class InsFillArrayData
extends Ins31t {
    public InsFillArrayData() {
        super(Opcode.FILL_ARRAY_DATA);
    }

    public InsArrayData getInsArrayData() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            return null;
        }
        Ins ins = instructionList.getAtAddress(this.getTargetAddress());
        if (ins instanceof InsArrayData) {
            return (InsArrayData)ins;
        }
        return null;
    }

    Ins22c findNewArrayLazy() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            return null;
        }
        int index = this.getIndex();
        Ins ins = instructionList.get(index - 1);
        if (ins.getOpcode() == Opcode.NEW_ARRAY) {
            Ins22c ins22c = (Ins22c)ins;
            if (this.getRegister(0) == ins22c.getRegister(0)) {
                return ins22c;
            }
        }
        return null;
    }

    @Override
    String getLabelPrefix() {
        return ":array_";
    }
}

