/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.NumberBlock;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliPayloadArray;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.dex.smali.model.SmaliValueX;
import com.reandroid.utils.NumberX;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;
import java.util.Iterator;

public class InsArrayDataList
extends CountedBlockList<ArrayDataEntry> {
    private final IntegerReference widthReference;

    public InsArrayDataList(IntegerReference widthReference, IntegerReference countReference) {
        super(new EntryCreator(widthReference), new WidthCheckingReference(widthReference, countReference));
        this.widthReference = widthReference;
    }

    @Override
    public void setSize(int size) {
        super.setSize(size);
        IntegerReference countReference = this.getCountReference();
        if (size != countReference.get()) {
            countReference.set(size);
        }
    }

    public int getWidth() {
        return this.widthReference.get();
    }

    public void setWidth(int width) {
        this.widthReference.set(width);
        if (width == 0) {
            this.clear();
        } else {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                ((ArrayDataEntry)this.get(i)).width(width);
            }
        }
    }

    public void ensureWidth(int width) {
        if (width > this.getWidth()) {
            this.setWidth(NumberX.toStandardWidth(width));
        }
    }

    public void put(int index, long value) {
        this.ensureSize(index + 1);
        ((ArrayDataEntry)this.get(index)).set(value);
    }

    public void addValues(long[] values) {
        int length = values.length;
        int index = this.size();
        this.setSize(index + length);
        for (int i = 0; i < length; ++i) {
            long value = values[i];
            this.ensureWidth(NumberX.widthOfSigned(value));
            ((ArrayDataEntry)this.get(index + i)).set(value);
        }
    }

    public void addValues(int[] values) {
        int length = values.length;
        int index = this.size();
        this.setSize(index + length);
        for (int i = 0; i < length; ++i) {
            long value = values[i];
            this.ensureWidth(NumberX.widthOfSigned(value));
            ((ArrayDataEntry)this.get(index + i)).set(value);
        }
    }

    public void addValues(short[] values) {
        int length = values.length;
        int index = this.size();
        this.ensureWidth(2);
        this.setSize(index + length);
        for (int i = 0; i < length; ++i) {
            ((ArrayDataEntry)this.get(index + i)).set((long)values[i]);
        }
    }

    public void addValues(byte[] values) {
        int length = values.length;
        int index = this.size();
        this.ensureWidth(1);
        this.setSize(index + length);
        for (int i = 0; i < length; ++i) {
            ((ArrayDataEntry)this.get(index + i)).set((long)values[i]);
        }
    }

    public void addValues(char[] values) {
        int length = values.length;
        int index = this.size();
        this.setSize(index + length);
        for (int i = 0; i < length; ++i) {
            long value = values[i];
            this.ensureWidth(NumberX.widthOfSigned(value));
            ((ArrayDataEntry)this.get(index + i)).set(value);
        }
    }

    public void addValues(float[] values) {
        int length = values.length;
        int index = this.size();
        this.ensureWidth(4);
        this.setSize(index + length);
        for (int i = 0; i < length; ++i) {
            long value = Float.floatToIntBits(values[i]);
            ((ArrayDataEntry)this.get(index + i)).set(value);
        }
    }

    public void addValues(double[] values) {
        int length = values.length;
        int index = this.size();
        this.ensureWidth(8);
        this.setSize(index + length);
        for (int i = 0; i < length; ++i) {
            long value = Double.doubleToLongBits(values[i]);
            ((ArrayDataEntry)this.get(index + i)).set(value);
        }
    }

    public void addValue(long value) {
        this.ensureWidth(NumberX.widthOfSigned(value));
        ((ArrayDataEntry)this.createNext()).set(value);
    }

    public long[] getValues() {
        int size = this.size();
        long[] results = new long[size];
        for (int i = 0; i < size; ++i) {
            results[i] = ((ArrayDataEntry)this.get(i)).getLong();
        }
        return results;
    }

    public int[] getValuesAsInt() {
        int size = this.size();
        int[] results = new int[size];
        for (int i = 0; i < size; ++i) {
            results[i] = (int)((ArrayDataEntry)this.get(i)).getLong();
        }
        return results;
    }

    public short[] getValuesAsShort() {
        int size = this.size();
        short[] results = new short[size];
        for (int i = 0; i < size; ++i) {
            results[i] = (short)((ArrayDataEntry)this.get(i)).getLong();
        }
        return results;
    }

    public byte[] getValuesAsByte() {
        int size = this.size();
        byte[] results = new byte[size];
        for (int i = 0; i < size; ++i) {
            results[i] = (byte)((ArrayDataEntry)this.get(i)).getLong();
        }
        return results;
    }

    public char[] getValuesAsChar() {
        int size = this.size();
        char[] results = new char[size];
        for (int i = 0; i < size; ++i) {
            results[i] = (char)((ArrayDataEntry)this.get(i)).getLong();
        }
        return results;
    }

    public float[] getValuesAsFloat() {
        int size = this.size();
        float[] results = new float[size];
        for (int i = 0; i < size; ++i) {
            results[i] = Float.intBitsToFloat(((ArrayDataEntry)this.get(i)).get());
        }
        return results;
    }

    public double[] getValuesAsDouble() {
        int size = this.size();
        double[] results = new double[size];
        for (int i = 0; i < size; ++i) {
            results[i] = Double.longBitsToDouble(((ArrayDataEntry)this.get(i)).getLong());
        }
        return results;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.clearChildes();
        this.updateCountReference();
    }

    public void fromSmali(SmaliPayloadArray smaliPayloadArray) {
        this.setWidth(smaliPayloadArray.getWidth());
        SmaliSet entries = smaliPayloadArray.getEntries();
        int size = entries.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            ((ArrayDataEntry)this.get(i)).fromSmali((SmaliValueX)entries.get(i));
        }
        this.updateCountReference();
    }

    public void toSmali(SmaliPayloadArray smaliPayloadArray) {
        int size = this.size();
        smaliPayloadArray.setWidth(this.getWidth());
        for (int i = 0; i < size; ++i) {
            smaliPayloadArray.addEntry(((ArrayDataEntry)this.get(i)).toSmali());
        }
    }

    public void append(TypeKey arrayType, SmaliWriter writer) throws IOException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ArrayDataEntry entry = (ArrayDataEntry)iterator.next();
            writer.newLine();
            entry.append(arrayType, writer);
        }
    }

    public void merge(InsArrayDataList dataList) {
        this.setWidth(dataList.getWidth());
        int size = dataList.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            ((ArrayDataEntry)this.get(i)).merge((ArrayDataEntry)dataList.get(i));
        }
        this.updateCountReference();
    }

    @Override
    public String toString() {
        return "width = " + this.getWidth() + ", size = " + this.size() + "\n  " + StringsUtil.join(this.iterator(), (Object)"\n  ");
    }

    static class WidthCheckingReference
    implements IntegerReference {
        private final IntegerReference width;
        private final IntegerReference reference;

        public WidthCheckingReference(IntegerReference width, IntegerReference reference) {
            this.width = width;
            this.reference = reference;
        }

        @Override
        public int get() {
            if (this.width.get() == 0) {
                return 0;
            }
            return this.reference.get();
        }

        @Override
        public void set(int value) {
            this.reference.set(value);
        }

        public String toString() {
            return Integer.toString(this.get());
        }
    }

    static class EntryCreator
    implements Creator<ArrayDataEntry> {
        private final IntegerReference width;

        public EntryCreator(IntegerReference width) {
            this.width = width;
        }

        @Override
        public ArrayDataEntry newInstance() {
            return new ArrayDataEntry(this.width.get());
        }
    }

    public static class ArrayDataEntry
    extends NumberBlock
    implements SmaliFormat {
        public ArrayDataEntry(int width) {
            super(width);
        }

        public void fromSmali(SmaliValueX smaliValueX) {
            this.set(smaliValueX.getValueAsLong());
        }

        public SmaliValueX toSmali() {
            return new SmaliValueX(this.width(), this.getLong());
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            this.append(null, writer);
        }

        public void append(TypeKey arrayType, SmaliWriter writer) throws IOException {
            writer.appendHex(this.width(), this.getLong());
            this.appendFloatOrDoubleComment(arrayType, writer);
        }

        private void appendFloatOrDoubleComment(TypeKey arrayType, SmaliWriter writer) {
            if (arrayType == null) {
                return;
            }
            long data = this.getLong();
            if (data == 0L) {
                return;
            }
            TypeKey typeKey = arrayType.setArrayDimension(0);
            if (TypeKey.TYPE_F.equals(typeKey)) {
                float f = Float.intBitsToFloat((int)data);
                writer.appendComment(f + "f");
            } else if (TypeKey.TYPE_D.equals(typeKey)) {
                double d = Double.longBitsToDouble(data);
                writer.appendComment(Double.toString(d));
            }
        }

        public void merge(ArrayDataEntry entry) {
            this.set(entry.getLong());
        }

        public int hashCode() {
            return Block.hashCodeOf(this.getBytesInternal());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ArrayDataEntry other = (ArrayDataEntry)obj;
            return Block.areEqual(this.getBytesInternal(), other.getBytesInternal());
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            String hex = this.toHexString();
            builder.append(hex);
            int width = this.width();
            if (width == 1) {
                builder.append('t');
            } else if (width == 2) {
                builder.append('S');
            } else if (width == 8 && (this.getLong() & Integer.MIN_VALUE) != 0L) {
                builder.append('L');
            }
            return builder.toString();
        }
    }
}

