/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.data.FixedDexContainerWithTool;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.ins.ExceptionLabel;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.LabelsSet;
import com.reandroid.dex.ins.TryItem;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCodeExceptionHandler;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;

public abstract class ExceptionHandler
extends FixedDexContainerWithTool
implements SmaliRegion,
Iterable<Label>,
LabelsSet {
    private final Ule128Item catchAddress;
    private final ExceptionLabel startLabel;
    private final ExceptionLabel endLabel;
    private final ExceptionLabel handlerLabel;
    private final ExceptionLabel catchLabel;
    private Label[] mLabels;

    private ExceptionHandler(int childesCount, Ule128Item catchAddress, int index) {
        super(childesCount);
        this.catchAddress = catchAddress;
        if (catchAddress != null) {
            this.addChild(index, catchAddress);
        }
        this.startLabel = new TryStartLabel(this);
        this.endLabel = new TryEndLabel(this);
        this.handlerLabel = new HandlerLabel(this);
        this.catchLabel = new CatchLabel(this);
        this.mLabels = new Label[]{this.startLabel, this.endLabel, this.handlerLabel, this.catchLabel};
    }

    ExceptionHandler(int childesCount) {
        this(childesCount + 1, new Ule128Item(), childesCount);
    }

    ExceptionHandler() {
        this(0, null, 0);
    }

    public TypeKey getKey() {
        return null;
    }

    public void setKey(TypeKey typeKey) {
    }

    public abstract boolean isCatchAll();

    public boolean isAddressBounded(int address) {
        if (address == -1) {
            return true;
        }
        return address >= this.getStartAddress() && address <= this.getAddress();
    }

    public int getInstructionCount() {
        return CollectionUtil.count(this.getTryInstructions());
    }

    public Iterator<Ins> getTryInstructions() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            return EmptyIterator.of();
        }
        return instructionList.iteratorByAddress(this.getStartLabel().getTargetAddress(), this.getCodeUnit());
    }

    private InstructionList getInstructionList() {
        TryItem tryItem = this.getTryItem();
        if (tryItem != null) {
            return tryItem.getInstructionList();
        }
        return null;
    }

    public abstract boolean traps(TypeKey var1);

    abstract TypeId getTypeId();

    @Override
    public abstract SmaliDirective getSmaliDirective();

    Ule128Item getCatchAddressUle128() {
        return this.catchAddress;
    }

    public Iterator<Label> getLabels() {
        return this.iterator();
    }

    @Override
    public Iterator<Label> iterator() {
        return ArrayIterator.of(this.mLabels);
    }

    public ExceptionLabel getHandlerLabel() {
        return this.handlerLabel;
    }

    public ExceptionLabel getStartLabel() {
        return this.startLabel;
    }

    public ExceptionLabel getEndLabel() {
        return this.endLabel;
    }

    public ExceptionLabel getCatchLabel() {
        return this.catchLabel;
    }

    public void refreshAddresses() {
        Ins handlerIns = this.getHandlerLabel().getTargetIns();
        Ins startIns = this.getStartLabel().getTargetIns();
        Ins endIns = this.getEndLabel().getTargetIns();
        Ins catchIns = this.getCatchLabel().getTargetIns();
        if (handlerIns != null && startIns != null && endIns != null && catchIns != null) {
            int handlerAddress = handlerIns.getAddress();
            int startAddress = startIns.getAddress();
            int catchAddress = catchIns.getAddress();
            this.setStartAddress(startIns.getAddress());
            this.setCatchAddress(catchAddress);
            this.setCodeUnit(handlerAddress - startAddress);
        }
    }

    public int getCatchAddress() {
        return this.getCatchAddressUle128().get();
    }

    public void setCatchAddress(int address) {
        this.getCatchAddressUle128().set(address);
    }

    public int getAddress() {
        return this.getStartAddress() + this.getCodeUnit();
    }

    public void setAddress(int address) {
        this.setCodeUnit(address - this.getStartAddress());
    }

    public int getStartAddress() {
        TryItem tryItem = this.getTryItem();
        if (tryItem != null) {
            return tryItem.getStartAddress();
        }
        return 0;
    }

    public void setStartAddress(int address) {
        TryItem tryItem = this.getTryItem();
        if (tryItem != null) {
            tryItem.setStartAddress(address);
        }
    }

    public int getCodeUnit() {
        TryItem tryItem = this.getTryItem();
        if (tryItem != null) {
            return tryItem.getCatchCodeUnit();
        }
        return 0;
    }

    public void setCodeUnit(int value) {
        TryItem tryItem = this.getTryItem();
        if (tryItem != null) {
            tryItem.getHandlerOffset().setCatchCodeUnit(value);
        }
    }

    TryItem getTryItem() {
        return this.getParentInstance(TryItem.class);
    }

    public void onRemove() {
        this.mLabels = null;
        this.setParent(null);
    }

    public void removeSelf() {
        TryItem tryItem = this.getTryItem();
        if (tryItem != null) {
            tryItem.remove(this);
        }
    }

    public boolean isRemoved() {
        return this.getParent() == null;
    }

    int compareHandler(ExceptionHandler handler) {
        if (handler == this) {
            return 0;
        }
        int i = CompareUtil.compare(this.getAddress(), handler.getAddress());
        if (i != 0) {
            return i;
        }
        TryItem tryItem1 = this.getTryItem();
        TryItem tryItem2 = handler.getTryItem();
        i = CompareUtil.compare(tryItem1.getIndex(), tryItem2.getIndex());
        if (i != 0) {
            return i;
        }
        i = CompareUtil.compare(this.isCatchAll(), handler.isCatchAll());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getIndex(), handler.getIndex());
    }

    public void merge(ExceptionHandler handler) {
        this.catchAddress.set(handler.getCatchAddress());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
    }

    public void fromSmali(SmaliCodeExceptionHandler smaliCodeExceptionHandler) {
        this.getHandlerLabel().setTargetAddress(smaliCodeExceptionHandler.getAddress());
        this.getStartLabel().setTargetAddress(smaliCodeExceptionHandler.getStart().getAddress());
        this.getEndLabel().setTargetAddress(smaliCodeExceptionHandler.getEnd().getAddress());
        this.getCatchLabel().setTargetAddress(smaliCodeExceptionHandler.getCatchLabel().getAddress());
    }

    boolean isTypeEqual(ExceptionHandler handler) {
        return true;
    }

    int getTypeHashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionHandler handler = (ExceptionHandler)obj;
        return this.getStartAddress() == handler.getStartAddress() && this.getAddress() == handler.getAddress() && this.getCatchAddress() == handler.getCatchAddress() && this.isTypeEqual(handler);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getStartAddress();
        hash = hash * 31 + this.getAddress();
        hash = hash * 31 + this.getCatchAddress();
        hash = hash * 31 + this.getTypeHashCode();
        return hash;
    }

    public String toString() {
        return this.getHandlerLabel().toString();
    }

    static boolean areSimilar(ExceptionHandler handler1, ExceptionHandler handler2) {
        if (handler1 == null) {
            return handler2 == null;
        }
        if (handler2 == null) {
            return false;
        }
        if (handler1.getCatchAddress() != handler2.getCatchAddress()) {
            return false;
        }
        return ObjectsUtil.equals(handler1.getKey(), handler2.getKey());
    }

    public static class CatchLabel
    extends AbstractExceptionLabel {
        CatchLabel(ExceptionHandler handler) {
            super(handler);
        }

        @Override
        public int getAddress() {
            return this.getHandler().getStartLabel().getAddress();
        }

        @Override
        public int getTargetAddress() {
            return this.getHandler().getCatchAddress();
        }

        @Override
        public void setTargetAddress(int targetAddress) {
            this.getHandler().setCatchAddress(targetAddress);
        }

        @Override
        public String getLabelName() {
            return HexUtil.toHex(":" + this.getHandler().getSmaliDirective().getName() + "_", this.getTargetAddress(), 1);
        }

        @Override
        public int getSortOrder() {
            return 4;
        }

        @Override
        public boolean isEqualExtraLine(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CatchLabel label = (CatchLabel)obj;
            if (this.getHandler() == label.getHandler()) {
                return true;
            }
            return this.getTargetAddress() == label.getTargetAddress() && this.getHandler().getSmaliDirective().equals(label.getHandler().getSmaliDirective());
        }

        public String toString() {
            return this.getLabelName();
        }
    }

    public static class TryEndLabel
    extends AbstractExceptionLabel {
        TryEndLabel(ExceptionHandler handler) {
            super(handler);
        }

        @Override
        public int getAddress() {
            return this.getHandler().getAddress();
        }

        @Override
        public int getTargetAddress() {
            return this.getHandler().getAddress();
        }

        @Override
        public void setTargetAddress(int targetAddress) {
            this.getHandler().setAddress(targetAddress);
        }

        @Override
        public String getLabelName() {
            int startAddress = this.getHandler().getStartLabel().getTargetAddress();
            return HexUtil.toHex(":try_end_", startAddress, 1);
        }

        @Override
        public int getSortOrder() {
            return 2;
        }

        @Override
        public boolean isEqualExtraLine(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TryEndLabel label = (TryEndLabel)obj;
            if (this.getHandler() == label.getHandler()) {
                return true;
            }
            return this.getTargetAddress() == label.getTargetAddress();
        }

        public String toString() {
            return this.getLabelName();
        }
    }

    public static class TryStartLabel
    extends AbstractExceptionLabel {
        TryStartLabel(ExceptionHandler handler) {
            super(handler);
        }

        @Override
        public int getAddress() {
            return this.getHandler().getAddress();
        }

        @Override
        public int getTargetAddress() {
            return this.getHandler().getStartAddress();
        }

        @Override
        public void setTargetAddress(int targetAddress) {
            this.getHandler().setStartAddress(targetAddress);
        }

        @Override
        public String getLabelName() {
            return HexUtil.toHex(":try_start_", this.getTargetAddress(), 1);
        }

        @Override
        public int getSortOrder() {
            return 6;
        }

        @Override
        public boolean isEqualExtraLine(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TryStartLabel label = (TryStartLabel)obj;
            if (this.getHandler() == label.getHandler()) {
                return true;
            }
            return this.getTargetAddress() == label.getTargetAddress();
        }

        public String toString() {
            return this.getLabelName();
        }
    }

    public static class HandlerLabel
    extends AbstractExceptionLabel {
        HandlerLabel(ExceptionHandler handler) {
            super(handler);
        }

        @Override
        public int getAddress() {
            return this.getHandler().getAddress();
        }

        @Override
        public int getTargetAddress() {
            return this.getHandler().getAddress();
        }

        @Override
        public void setTargetAddress(int targetAddress) {
            this.getHandler().setAddress(targetAddress);
        }

        @Override
        public void updateTarget() {
            this.getHandler().refreshAddresses();
        }

        @Override
        public String getLabelName() {
            ExceptionHandler handler = this.getHandler();
            StringBuilder builder = new StringBuilder();
            builder.append('.');
            builder.append(handler.getSmaliDirective().getName());
            builder.append(' ');
            TypeId typeId = handler.getTypeId();
            if (typeId != null) {
                builder.append(typeId.getName());
                builder.append(' ');
            }
            builder.append("{");
            builder.append(handler.getStartLabel().getLabelName());
            builder.append(" .. ");
            builder.append(handler.getEndLabel().getLabelName());
            builder.append("} ");
            builder.append(handler.getCatchLabel().getLabelName());
            return builder.toString();
        }

        @Override
        public int getSortOrder() {
            return 3;
        }

        @Override
        public boolean isEqualExtraLine(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HandlerLabel label = (HandlerLabel)obj;
            return this.getHandler() == label.getHandler();
        }

        @Override
        public int compareLabelName(Label label) {
            return this.getHandler().compareHandler(((HandlerLabel)label).getHandler());
        }

        @Override
        public void appendExtra(SmaliWriter writer) throws IOException {
            ExceptionHandler handler = this.getHandler();
            handler.getSmaliDirective().append(writer);
            TypeId typeId = handler.getTypeId();
            if (typeId != null) {
                typeId.append(writer);
                writer.append(' ');
            }
            writer.append("{");
            writer.appendLabelName(handler.getStartLabel().getLabelName());
            writer.append(" .. ");
            writer.appendLabelName(handler.getEndLabel().getLabelName());
            writer.append("} ");
            writer.appendLabelName(handler.getCatchLabel().getLabelName());
        }

        public String toString() {
            return this.getLabelName();
        }
    }

    static abstract class AbstractExceptionLabel
    implements ExceptionLabel {
        private Ins targetIns;
        private final ExceptionHandler handler;

        AbstractExceptionLabel(ExceptionHandler handler) {
            this.handler = handler;
        }

        @Override
        public ExceptionHandler getHandler() {
            return this.handler;
        }

        @Override
        public Ins getTargetIns() {
            Ins ins = this.targetIns;
            if (ins != null && ins.isRemoved()) {
                ins = null;
                this.targetIns = null;
            }
            return ins;
        }

        @Override
        public void setTargetIns(Ins targetIns) {
            if (targetIns != this.targetIns) {
                this.targetIns = targetIns;
                if (targetIns != null) {
                    targetIns.addExtraLine(this);
                }
            }
        }

        @Override
        public void updateTarget() {
        }
    }
}

