/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.id;

import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.data.EncodedArray;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.MethodHandleId;
import com.reandroid.dex.id.ProtoId;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.ArrayKey;
import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.CallSiteKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodHandleKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.reference.DataItemIndirectReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.SectionValue;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;

public class CallSiteId
extends IdItem
implements Comparable<CallSiteId> {
    private final DataItemIndirectReference<EncodedArray> encodedArrayReference = new DataItemIndirectReference<EncodedArray>(SectionType.ENCODED_ARRAY, this, 0, UsageMarker.USAGE_CALL_SITE);
    public static final String NAME_PREFIX = ObjectsUtil.of("call_site_");

    public CallSiteId() {
        super(4);
    }

    @Override
    public CallSiteKey getKey() {
        return this.checkKey(new CallSiteKey(this.getMethodHandle(), this.getMethodName(), this.getProto(), this.getArguments()));
    }

    @Override
    public void setKey(Key key) {
        CallSiteKey callSiteKey = (CallSiteKey)key;
        this.encodedArrayReference.setKey(callSiteKey.toArrayKey());
    }

    public String callSiteName() {
        return NAME_PREFIX + this.getIdx();
    }

    public MethodHandleKey getMethodHandle() {
        return this.getMethodHandleId().getKey();
    }

    public MethodHandleId getMethodHandleId() {
        return this.getValue(SectionType.METHOD_HANDLE, 0);
    }

    public void setMethodHandle(MethodHandleKey key) {
        if (!key.equals(this.getMethodHandle())) {
            this.setKey(this.getKey().changeMethodHandle(key));
        }
    }

    public StringKey getMethodName() {
        StringId stringId = this.getMethodNameId();
        if (stringId != null) {
            return stringId.getKey();
        }
        return null;
    }

    public void setMethodName(String methodName) {
        this.setMethodName(StringKey.create(methodName));
    }

    public void setMethodName(StringKey methodName) {
        if (!methodName.equals(this.getMethodName())) {
            this.setKey(this.getKey().changeName(methodName));
        }
    }

    public StringId getMethodNameId() {
        return this.getValue(SectionType.STRING_ID, 1);
    }

    public ProtoId getProtoId() {
        return this.getValue(SectionType.PROTO_ID, 2);
    }

    public ProtoKey getProto() {
        ProtoId protoId = this.getProtoId();
        if (protoId != null) {
            return protoId.getKey();
        }
        return null;
    }

    public void setProto(ProtoKey protoKey) {
        if (!protoKey.equals(this.getProto())) {
            this.setKey(this.getKey().changeProto(protoKey));
        }
    }

    public ArrayValueKey getArguments() {
        int size = this.getArgumentsSize();
        Key[] results = new Key[size];
        for (int i = 0; i < size; ++i) {
            results[i] = this.getArgument(i);
        }
        return ArrayValueKey.of(results);
    }

    public Iterator<DexValueBlock<?>> getArgumentValues() {
        EncodedArray encodedArray = this.getEncodedArray();
        if (encodedArray != null) {
            return encodedArray.iterator(3, encodedArray.size() - 3);
        }
        return EmptyIterator.of();
    }

    public Key getArgument(int i) {
        DexValueBlock<?> valueBlock = this.getArgumentValue(i);
        if (valueBlock != null) {
            return valueBlock.getKey();
        }
        return null;
    }

    public DexValueBlock<?> getArgumentValue(int i) {
        EncodedArray encodedArray;
        if (i >= 0 && (encodedArray = this.getEncodedArray()) != null) {
            return encodedArray.get(i + 3);
        }
        return null;
    }

    public int getArgumentsSize() {
        int size;
        EncodedArray encodedArray = this.getEncodedArray();
        if (encodedArray != null && (size = encodedArray.size()) > 0) {
            return size - 3;
        }
        return 0;
    }

    public void setArguments(ArrayKey<?> key) {
        if (!key.equals(this.getArguments())) {
            this.setKey(this.getKey().changeArguments(key));
        }
    }

    private <T1 extends IdItem> T1 getValue(SectionType<T1> sectionType, int index) {
        EncodedArray encodedArray = this.getEncodedArray();
        if (encodedArray == null) {
            return null;
        }
        DexValueBlock<?> value = encodedArray.get(index);
        if (!(value instanceof SectionValue)) {
            return null;
        }
        SectionValue sectionValue = (SectionValue)value;
        if (sectionValue.getSectionType() != sectionType) {
            return null;
        }
        return (T1)((IdItem)((SectionValue)value).getItem());
    }

    public EncodedArray getOrCreateEncodedArray() {
        return this.encodedArrayReference.getOrCreate();
    }

    public EncodedArray getEncodedArray() {
        return (EncodedArray)this.encodedArrayReference.getItem();
    }

    @Override
    void cacheItems() {
        this.encodedArrayReference.pullItem();
    }

    @Override
    public void refresh() {
        this.encodedArrayReference.refresh();
    }

    @Override
    public Iterator<IdItem> usedIds() {
        EncodedArray encodedArray = this.getEncodedArray();
        if (encodedArray == null) {
            return EmptyIterator.of();
        }
        return encodedArray.usedIds();
    }

    public SectionType<CallSiteId> getSectionType() {
        return SectionType.CALL_SITE_ID;
    }

    public void merge(CallSiteId callSiteId) {
        if (callSiteId == this) {
            return;
        }
        EncodedArray encodedArray = this.getOrCreateEncodedArray();
        encodedArray.merge(callSiteId.getEncodedArray());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.callSiteName());
        writer.append('(');
        this.getMethodNameId().append(writer);
        writer.append(", ");
        this.getProtoId().append(writer);
        Iterator<DexValueBlock<?>> iterator = this.getArgumentValues();
        while (iterator.hasNext()) {
            writer.append(", ");
            iterator.next().append(writer);
        }
        writer.append(')');
        this.getMethodHandle().append(writer, false);
    }

    @Override
    public int compareTo(CallSiteId callSiteId) {
        if (callSiteId == this) {
            return 0;
        }
        if (callSiteId == null) {
            return -1;
        }
        int i = CompareUtil.compare(this.getMethodHandleId(), callSiteId.getMethodHandleId());
        if (i != 0) {
            return i;
        }
        i = CompareUtil.compare(this.getArguments(), callSiteId.getArguments());
        if (i != 0) {
            return i;
        }
        i = CompareUtil.compare(this.getMethodNameId(), callSiteId.getMethodNameId());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getProtoId(), callSiteId.getProtoId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallSiteId callSiteId = (CallSiteId)o;
        return ObjectsUtil.equals(this.getEncodedArray(), callSiteId.getEncodedArray());
    }

    public int hashCode() {
        EncodedArray encodedArray = this.getEncodedArray();
        if (encodedArray != null) {
            return encodedArray.hashCode();
        }
        return 0;
    }

    public String toString() {
        return SmaliWriter.toStringSafe(this);
    }
}

